/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.ui.report.tree;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.report.tree.CheckBoxTreeCellComponent;

public class CheckBoxTreeCellEditor
extends CheckBoxTreeCellComponent
implements TreeCellEditor,
ItemListener {
    private static final long serialVersionUID = 2497464481840318274L;
    private static Log log = LogFactory.getLog(CheckBoxTreeCellEditor.class);
    protected Collection<CellEditorListener> cellEditorListeners;

    public CheckBoxTreeCellEditor(JTree parentTree, Set<TimerTask> uncheckedTaskList) {
        super(parentTree, uncheckedTaskList);
        this.addItemListener(this);
        this.cellEditorListeners = new ArrayList<CellEditorListener>();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        return this.getCheckBoxComponent(tree, value, selected, expanded, leaf, row);
    }

    @Override
    public Object getCellEditorValue() {
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.cellEditorListeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        for (CellEditorListener cellEditorListener : this.cellEditorListeners) {
            cellEditorListener.editingCanceled(e);
        }
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.cellEditorListeners.remove(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        ChangeEvent e = new ChangeEvent(this);
        for (CellEditorListener cellEditorListener : this.cellEditorListeners) {
            cellEditorListener.editingStopped(e);
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        TreePath editingPath;
        JCheckBox checkbox = (JCheckBox)e.getSource();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Tree checkbox state changed on " + checkbox.getText() + "(" + checkbox.isSelected() + ")"));
        }
        if ((editingPath = this.parentTree.getEditingPath()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current edition = " + editingPath));
            }
            this.updateChildreen(editingPath, checkbox.isSelected());
            this.parentTree.repaint();
        }
        this.stopCellEditing();
    }

    protected void updateChildreen(TreePath treePath, boolean select) {
        TimerTask lastPathComponent = (TimerTask)treePath.getLastPathComponent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recursive modification of = " + lastPathComponent.getName()));
        }
        if (select) {
            this.uncheckedTaskSet.remove(lastPathComponent);
        } else {
            this.uncheckedTaskSet.add(lastPathComponent);
        }
        for (TimerTask subtask : lastPathComponent.getSubTasks()) {
            TreePath subTreePath = treePath.pathByAddingChild(subtask);
            this.updateChildreen(subTreePath, select);
        }
    }
}

