/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.DataEventListener;
import org.chorem.jtimer.data.DataViolationException;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.io.DataLockingException;
import org.chorem.jtimer.io.GTimerTimeUtil;
import org.chorem.jtimer.io.Saver;

public class GTimerIncrementalSaver
extends java.util.TimerTask
implements Saver,
DataEventListener {
    private static final long serialVersionUID = 4999800626942050992L;
    private static Log log = LogFactory.getLog(GTimerIncrementalSaver.class);
    protected static final String GTIMER_SUBTASK_SEPARATOR = "/";
    protected static final String GTIMER_FILE_VERSION = "1.2";
    protected static final String GTIMER_PROJECT_EXTENSION = "project";
    protected static final String GTIMER_TASK_EXTENSION = "task";
    protected static final String GTIMER_ANNOTATION_EXTENSION = "ann";
    protected static final String GTIMER_EMPTY_PROJECT_NAME = "No project";
    protected static final String LOCK_FILE_NAME = ".lock";
    protected String saveDirectory = System.getProperty("user.home") + File.separator + ".gtimer";
    protected FileLock lock;
    protected RandomAccessFile raf;
    protected FileChannel channel;
    protected Timer autoSaveTimer;
    protected long autoSaveDelay = 300000L;
    protected Collection<TimerTask> runningTasks = Collections.synchronizedCollection(new ArrayList());

    public GTimerIncrementalSaver() {
        this.autoSaveTimer = new Timer();
    }

    @Override
    public void setSaveDirectory(String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        this.saveDirectory = directory;
    }

    @Override
    public void setAutoSaveDelay(long autoSaveDelay) {
        if (autoSaveDelay > 0L) {
            this.autoSaveDelay = autoSaveDelay;
        }
    }

    protected void checkSaveDirectory() {
        File gTimerFileDir = new File(this.saveDirectory);
        if (!gTimerFileDir.exists()) {
            gTimerFileDir.mkdirs();
        }
    }

    @Override
    public void lock() throws DataLockingException {
        try {
            this.checkSaveDirectory();
            this.raf = new RandomAccessFile(this.saveDirectory + File.separator + LOCK_FILE_NAME, "rw");
            this.channel = this.raf.getChannel();
            this.lock = this.channel.tryLock();
            if (this.lock == null) {
                throw new DataLockingException("Cannot get lock");
            }
            this.runningTasks.clear();
            this.autoSaveTimer.schedule((java.util.TimerTask)this, this.autoSaveDelay, this.autoSaveDelay);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Cannot get lock", (Throwable)e);
            }
            throw new DataLockingException("Cannot get lock", e);
        }
    }

    @Override
    public void unlock() throws DataLockingException {
        if (this.lock != null) {
            try {
                this.lock.release();
                this.cancel();
                this.autoSaveTimer.purge();
                this.autoSaveTimer.cancel();
                this.saveRunningTasks();
                this.runningTasks.clear();
                this.channel.close();
                this.raf.close();
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Cannot release lock", (Throwable)e);
                }
                throw new DataLockingException("Cannot release lock", e);
            }
        }
    }

    @Override
    public Collection<TimerProject> load() {
        Collection<TimerProject> result = this.gTimerLoad();
        return result;
    }

    protected Collection<TimerProject> gTimerLoad() {
        HashMap<String, TimerProject> mapNumberProject = new HashMap<String, TimerProject>();
        File gTimerFileDir = new File(this.saveDirectory);
        Pattern pPatronNommage = Pattern.compile("^(\\d+)\\.project$");
        for (File f : gTimerFileDir.listFiles()) {
            Matcher m;
            if (!f.isFile() || !f.canRead() || !(m = pPatronNommage.matcher(f.getName())).find()) continue;
            String number = m.group(1);
            try {
                int projectNumber = Integer.parseInt(number);
                TimerProject p = this.getProjectFromFile(f);
                if (p == null) continue;
                p.setNumber(projectNumber);
                mapNumberProject.put(number, p);
            }
            catch (NumberFormatException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + f.getName() + " as gtimer file"), (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't read file", (Throwable)e);
            }
        }
        pPatronNommage = Pattern.compile("^(\\d+)\\.task$");
        TreeMap<TimerTask, TimerProject> taskToPostManaged = new TreeMap<TimerTask, TimerProject>(new Comparator<TimerTask>(){

            @Override
            public int compare(TimerTask t1, TimerTask t2) {
                int numberOfSeparatorInT2;
                int numberOfSeparatorInT1 = t1.getName().split(GTimerIncrementalSaver.GTIMER_SUBTASK_SEPARATOR).length;
                int compare = numberOfSeparatorInT1 - (numberOfSeparatorInT2 = t2.getName().split(GTimerIncrementalSaver.GTIMER_SUBTASK_SEPARATOR).length);
                if (compare == 0) {
                    compare = -1;
                }
                return compare;
            }
        });
        for (File f : gTimerFileDir.listFiles()) {
            Matcher m;
            if (!f.isFile() || !f.canRead() || !(m = pPatronNommage.matcher(f.getName())).find()) continue;
            String number = m.group(1);
            try {
                int taskNumber = Integer.parseInt(number);
                TimerTask task = this.parseTaskFromFile(mapNumberProject, f, taskToPostManaged);
                if (task == null) continue;
                task.setNumber(taskNumber);
                this.parseAnnotations(task);
            }
            catch (NumberFormatException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't parse " + f.getName() + " as gtimer file"), (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't parse task file", (Throwable)e);
            }
        }
        this.parseTaskFromSavedMap(taskToPostManaged);
        if (log.isDebugEnabled()) {
            this.backupGTimerFiles();
        }
        Collection<TimerProject> projects = mapNumberProject.values();
        return projects;
    }

    protected TimerProject getProjectFromFile(File projectFile) throws IOException {
        Properties prop = new Properties();
        prop.load(new BufferedInputStream(new FileInputStream(projectFile)));
        log.debug((Object)("Load project (" + projectFile.getName() + ") : " + prop.getProperty("Name")));
        TimerProject p = null;
        if (GTIMER_FILE_VERSION.equals(prop.get("Format"))) {
            p = new TimerProject();
            p.setName(prop.getProperty("Name"));
            try {
                String creationTimeStamp = prop.getProperty("Created");
                long timestampinms = Long.parseLong(creationTimeStamp) * 1000L;
                p.setCreationDate(new Date(timestampinms));
            }
            catch (NumberFormatException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Invalid 'Created' timestamp", (Throwable)e);
                }
                p.setCreationDate(new Date(0L));
            }
            p.setClosed(prop.getProperty("Options").equals("1"));
        } else {
            log.warn((Object)("Invalid file format. Excepted 1.2, found " + prop.get("Format")));
        }
        return p;
    }

    protected TimerTask parseTaskFromFile(Map<String, TimerProject> mapNumberProject, File taskFile, SortedMap<TimerTask, TimerProject> taskToManage) throws IOException {
        TimerTask t = null;
        Pattern dataPattern = Pattern.compile("(\\d{4})(\\d{2})(\\d{2})");
        Properties prop = new Properties();
        prop.load(new BufferedInputStream(new FileInputStream(taskFile)));
        if (GTIMER_FILE_VERSION.equals(prop.get("Format"))) {
            t = new TimerTask();
            try {
                String creationTimeStamp = prop.getProperty("Created");
                long timestampinms = Long.parseLong(creationTimeStamp) * 1000L;
                t.setCreationDate(new Date(timestampinms));
            }
            catch (NumberFormatException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Invalid 'Created' timestamp for " + taskFile), (Throwable)e);
                }
                t.setCreationDate(new Date(0L));
            }
            t.setClosed(prop.getProperty("Options").equals("1"));
            String gtimerTaskName = prop.getProperty("Name");
            t.setName(gtimerTaskName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load task (" + taskFile.getName() + ") : " + gtimerTaskName));
            }
            for (Object key : prop.keySet()) {
                String sKey = (String)key;
                Matcher m = dataPattern.matcher(sKey);
                if (!m.find()) continue;
                try {
                    Date keyDate = GTimerTimeUtil.yyyyMMdd2Date(sKey);
                    String timeString = (String)prop.get(sKey);
                    t.setTime(keyDate, Long.valueOf(timeString));
                }
                catch (NumberFormatException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't convert " + prop.get(sKey) + " into long"));
                }
            }
            String taskProjectNumber = (String)prop.get("Project");
            TimerProject associatedProject = mapNumberProject.get(taskProjectNumber);
            if (associatedProject == null && taskProjectNumber.equals("-1")) {
                associatedProject = new TimerProject();
                associatedProject.setName(GTIMER_EMPTY_PROJECT_NAME);
                mapNumberProject.put(taskProjectNumber, associatedProject);
            }
            if (associatedProject != null) {
                taskToManage.put(t, associatedProject);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Put " + t.getName() + ", " + associatedProject.getName()));
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("task " + t.getName() + " is associated with a wrong project number " + prop.get("Project")));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Invalid file format. Excepted 1.2, found " + prop.get("Format")));
        }
        return t;
    }

    protected void parseAnnotations(TimerTask task) throws IOException {
        int taskNumber = task.getNumber();
        File annotationsTaskFile = new File(this.saveDirectory + File.separator + taskNumber + "." + GTIMER_ANNOTATION_EXTENSION);
        if (annotationsTaskFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Annotations found for task " + task.getName()));
            }
            Properties prop = new Properties();
            prop.load(new BufferedInputStream(new FileInputStream(annotationsTaskFile)));
            for (Object key : prop.keySet()) {
                String sKey = (String)key;
                try {
                    long timestamp = Long.parseLong(sKey);
                    Date dateTS = new Date(timestamp * 1000L);
                    String annoText = (String)prop.get(sKey);
                    task.addAnnotation(dateTS, annoText);
                }
                catch (NumberFormatException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't convert " + sKey + " into long"));
                }
            }
        }
    }

    protected void parseTaskFromSavedMap(SortedMap<TimerTask, TimerProject> taskToManage) {
        for (Map.Entry<TimerTask, TimerProject> entry : taskToManage.entrySet()) {
            TimerTask task;
            String gTimerTaskname;
            Object[] tabTaskNames;
            TimerTask currentTask = entry.getKey();
            TimerProject associatedProject = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Post process task " + currentTask.getName()));
            }
            if ((tabTaskNames = (gTimerTaskname = currentTask.getName()).split(GTIMER_SUBTASK_SEPARATOR)).length == 1) {
                associatedProject.addTask(currentTask);
                continue;
            }
            String realTaskName = tabTaskNames[tabTaskNames.length - 1];
            currentTask.setName(realTaskName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converting task " + gTimerTaskname + " in sub tasks"));
            }
            if ((task = this.findTask(associatedProject, Arrays.copyOfRange(tabTaskNames, 0, tabTaskNames.length - 1))) != null) {
                task.addTask(currentTask);
                continue;
            }
            log.debug((Object)("task " + Arrays.toString(tabTaskNames) + " cannot be found, add task to project"));
            currentTask.setName(gTimerTaskname);
            associatedProject.addTask(currentTask);
        }
    }

    protected TimerTask findTask(TimerTask parentTask, String[] taskNames) {
        TimerTask result = null;
        if (taskNames.length > 0) {
            for (TimerTask task : parentTask.getSubTasks()) {
                if (!task.getName().equals(taskNames[0])) continue;
                result = this.findTask(task, Arrays.copyOfRange(taskNames, 1, taskNames.length));
            }
        } else {
            result = parentTask;
        }
        return result;
    }

    protected void backupGTimerFiles() {
        block8: {
            File backupDirFile;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String nowString = dateFormat.format(new Date());
            String backupDir = this.saveDirectory + File.separator + "backups";
            String zipFileName = backupDir + File.separator + "backup-" + nowString + ".zip";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating backup archive : " + zipFileName));
            }
            if (!(backupDirFile = new File(backupDir)).exists()) {
                backupDirFile.mkdirs();
            }
            try {
                File[] filesInIt;
                byte[] buffer = new byte[1024];
                ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(zipFileName));
                File gtimerdir = new File(this.saveDirectory);
                for (File fileInIt : filesInIt = gtimerdir.listFiles()) {
                    int len;
                    String filename = fileInIt.getName();
                    if (!this.isGTimerFile(filename)) continue;
                    FileInputStream inFileStream = new FileInputStream(fileInIt);
                    outZip.putNextEntry(new ZipEntry(filename));
                    while ((len = inFileStream.read(buffer)) > 0) {
                        outZip.write(buffer, 0, len);
                    }
                    outZip.closeEntry();
                    inFileStream.close();
                }
                outZip.close();
            }
            catch (FileNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't create archive", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)"Can't create archive", (Throwable)e);
            }
        }
    }

    protected boolean isGTimerFile(String filename) {
        boolean result = false;
        if (filename.endsWith(".project") || filename.endsWith(".task") || filename.endsWith(".ann")) {
            result = true;
        }
        return result;
    }

    protected boolean saveProject(TimerProject project) {
        boolean result;
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save project : " + project.getName()));
            }
            result = false;
            String filename = this.saveDirectory + File.separator + project.getNumber() + "." + GTIMER_PROJECT_EXTENSION;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save project in " + filename));
            }
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "ISO-8859-1");
                long mscreatedtime = project.getCreationDate().getTime();
                String createdTime = String.valueOf(mscreatedtime / 1000L);
                out.write("Format: 1.2\n");
                out.write("Name: " + project.getName() + "\n");
                out.write("Created: " + createdTime + "\n");
                out.write("Options: " + (project.isClosed() ? "1" : "0") + "\n");
                ((Writer)out).close();
                result = true;
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block4;
                log.error((Object)"Can't save project information", (Throwable)e);
            }
        }
        return result;
    }

    protected boolean saveTask(TimerTask task) {
        String taskPrefixName = "";
        TimerTask currentTask = task;
        while (currentTask.getParent() != null) {
            if ((currentTask = currentTask.getParent()).getParent() == null) continue;
            taskPrefixName = currentTask.getName() + GTIMER_SUBTASK_SEPARATOR + taskPrefixName;
        }
        int associatedToProject = currentTask.getNumber();
        return this.saveTask(task, associatedToProject, taskPrefixName);
    }

    protected boolean saveTask(TimerTask task, int associatedToProject, String taskPrefixName) {
        boolean result;
        block7: {
            if (associatedToProject < 0) {
                throw new IllegalArgumentException("Task project number is invalid : " + associatedToProject);
            }
            if (taskPrefixName == null) {
                throw new IllegalArgumentException("Task prefix is null");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save task : " + task.getName()));
            }
            result = false;
            String filename = this.saveDirectory + File.separator + task.getNumber() + "." + GTIMER_TASK_EXTENSION;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Save task in " + filename));
            }
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "ISO-8859-1");
                long mscreatedtime = task.getCreationDate().getTime();
                String createdTime = String.valueOf(mscreatedtime / 1000L);
                out.write("Format: 1.2\n");
                out.write("Name: " + taskPrefixName + task.getName() + "\n");
                out.write("Created: " + createdTime + "\n");
                out.write("Options: " + (task.isClosed() ? "1" : "0") + "\n");
                out.write("Project: " + associatedToProject + "\n");
                out.write("Data:\n");
                for (Map.Entry<Date, Long> entry : task.getAllDaysAndTimes().entrySet()) {
                    Date date = entry.getKey();
                    String gtimerDate = GTimerTimeUtil.date2yyyyMMdd(date);
                    out.write(gtimerDate + " " + entry.getValue() + "\n");
                }
                ((Writer)out).close();
                result = true;
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Can't save task", (Throwable)e);
            }
        }
        return result;
    }

    protected void saveTaskAnnotation(TimerTask task) {
        int taskNumber = task.getNumber();
        File annotationTaskFile = new File(this.saveDirectory + File.separator + taskNumber + "." + GTIMER_ANNOTATION_EXTENSION);
        if (task.getAllDaysAnnotations() != null && !task.getAllDaysAnnotations().isEmpty()) {
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(annotationTaskFile), "ISO-8859-1");
                for (Map.Entry<Date, String> entry : task.getAllDaysAnnotations().entrySet()) {
                    Date date = entry.getKey();
                    String gtimerTS = String.valueOf(date.getTime() / 1000L);
                    out.write(gtimerTS + " " + entry.getValue() + "\n");
                }
                ((Writer)out).close();
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't save task", (Throwable)e);
                }
            }
        } else {
            annotationTaskFile.delete();
        }
    }

    @Override
    public void addProject(TimerProject project) {
        int projectNumber = this.getUnusedNumber(".project");
        project.setNumber(projectNumber);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting project number for " + project.getName() + " to " + projectNumber));
        }
        this.saveProject(project);
        for (TimerTask subtask : project.getSubTasks()) {
            this.addTask(subtask);
        }
    }

    @Override
    public void addTask(TimerTask task) {
        int taskNumber = this.getUnusedNumber(".task");
        task.setNumber(taskNumber);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting task number for " + task.getName() + " to " + taskNumber));
        }
        this.saveTask(task);
        for (TimerTask subtask : task.getSubTasks()) {
            this.addTask(subtask);
        }
    }

    protected int getUnusedNumber(String extention) {
        int foundProjectNumber = -1;
        File aGtimerFile = null;
        while ((aGtimerFile = new File(this.saveDirectory + File.separator + ++foundProjectNumber + extention)).exists()) {
        }
        return foundProjectNumber;
    }

    @Override
    public void dataLoaded(Collection<TimerProject> projects) {
    }

    @Override
    public void deleteProject(TimerProject project) {
        this.deleteTaskOrProject(project, GTIMER_PROJECT_EXTENSION);
    }

    @Override
    public void deleteTask(TimerTask task) {
        this.deleteTaskOrProject(task, GTIMER_TASK_EXTENSION);
    }

    protected void deleteTaskOrProject(TimerTask taskOrProject, String extension) {
        File fileToDelete;
        int fileNumber = taskOrProject.getNumber();
        if (extension.equals(GTIMER_TASK_EXTENSION) && (fileToDelete = new File(this.saveDirectory + File.separator + fileNumber + "." + GTIMER_ANNOTATION_EXTENSION)).exists()) {
            fileToDelete.delete();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Annotation file deleted for " + taskOrProject.getName() + "(" + fileToDelete.getPath() + ")"));
            }
        }
        for (TimerTask subtask : taskOrProject.getSubTasks()) {
            this.deleteTaskOrProject(subtask, GTIMER_TASK_EXTENSION);
        }
        fileToDelete = new File(this.saveDirectory + File.separator + fileNumber + "." + extension);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
            if (log.isDebugEnabled()) {
                log.debug((Object)("File deleted for " + taskOrProject.getName() + "(" + fileToDelete.getPath() + ")"));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Try to delete non existing file " + fileToDelete.getAbsolutePath()));
        }
    }

    @Override
    public void modifyProject(TimerProject project) {
        this.saveProject(project);
    }

    @Override
    public void modifyTask(TimerTask task) {
        if (!this.runningTasks.contains(task)) {
            this.saveTask(task);
        }
        this.saveTaskAnnotation(task);
        for (TimerTask subtask : task.getSubTasks()) {
            this.modifyTask(subtask);
        }
    }

    @Override
    public void setAnnotation(TimerTask task, Date date, String annotation) {
        this.saveTaskAnnotation(task);
    }

    @Override
    public void setTaskTime(TimerTask task, Date date, Long time) {
        if (!this.runningTasks.contains(task)) {
            this.saveTask(task);
        }
    }

    @Override
    public void postChangeClosedState(TimerTask task) {
        if (task instanceof TimerProject) {
            this.saveProject((TimerProject)task);
        } else if (!this.runningTasks.contains(task)) {
            this.saveTask(task);
        }
    }

    @Override
    public void preChangeClosedState(TimerTask task) {
    }

    @Override
    public void preMoveTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"preMoveTask event received");
        }
    }

    @Override
    public void postMoveTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"postMoveTask event received");
        }
        this.modifyTask(task);
    }

    @Override
    public void postMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
        this.modifyTask(destinationTask);
    }

    @Override
    public void preMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }

    @Override
    public void startTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"startTask event received");
        }
        this.runningTasks.add(task);
    }

    @Override
    public void stopTask(TimerTask task) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"stopTask event received");
        }
        this.runningTasks.remove(task);
        this.saveTask(task);
    }

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Saver wake up");
        }
        this.saveRunningTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRunningTasks() {
        Collection<TimerTask> collection = this.runningTasks;
        synchronized (collection) {
            for (TimerTask task : this.runningTasks) {
                this.saveTask(task);
            }
        }
    }

    @Override
    public void checkSetAnnotation(TimerTask task, Date date, String value) {
    }

    @Override
    public void checkAddProject(TimerProject project) {
        this.checkName(project);
    }

    @Override
    public void checkAddTask(TimerTask parent, TimerTask task) {
        this.checkName(task);
    }

    protected void checkName(TimerTask task) {
        String name = task.getName();
        if (name.trim().length() <= 0) {
            throw new DataViolationException("Can't add task", "vetoable.saver.empty.name");
        }
        if (name.indexOf(GTIMER_SUBTASK_SEPARATOR) != -1) {
            throw new DataViolationException("Can't add task", "vetoable.saver.invalid.characters");
        }
    }

    @Override
    public void checkChangeClosedState(TimerTask task) {
    }

    @Override
    public void checkDeleteProject(TimerProject project) {
    }

    @Override
    public void checkDeleteTask(TimerTask task) {
    }

    @Override
    public void checkModifyProject(TimerProject project) {
    }

    @Override
    public void checkModifyTask(TimerTask task) {
    }

    @Override
    public void checkMoveTask(TimerTask task, TimerTask taskToMoveTo) {
    }

    @Override
    public void checkSetTaskTime(TimerTask task, Date date, Long value) {
    }

    @Override
    public void checkMergeTasks(TimerTask destinationTask, List<TimerTask> otherTasks) {
    }
}

