/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.entities;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

public class TimerTaskHelper {
    protected TimerTaskHelper() {
    }

    public static List<TimerTask> getSubTasksOrderedByName(TimerTask task) {
        List<TimerTask> taksToSort = task.getSubTasks();
        ArrayList<TimerTask> subTasksCopy = new ArrayList<TimerTask>(taksToSort);
        Comparator<TimerTask> c = new Comparator<TimerTask>(){

            @Override
            public int compare(TimerTask o1, TimerTask o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(subTasksCopy, c);
        return subTasksCopy;
    }

    public static long getAllTotalTime(TimerTask task) {
        long totalTime = 0L;
        for (Long t : task.getAllDaysAndTimes().values()) {
            totalTime += t.longValue();
        }
        for (TimerTask t2 : task.getSubTasks()) {
            totalTime += TimerTaskHelper.getAllTotalTime(t2);
        }
        return totalTime;
    }

    public static long getTotalTime(TimerTask task, Date date) {
        long result = 0L;
        result = task.getTime(date);
        for (TimerTask t2 : task.getSubTasks()) {
            result += TimerTaskHelper.getTotalTime(t2, date);
        }
        return result;
    }

    public static Date getTaskFirstDateOfTiming(TimerTask task) {
        Date date = null;
        SortedMap<Date, Long> allTiming = task.getAllDaysAndTimes();
        if (!allTiming.isEmpty()) {
            date = allTiming.firstKey();
        }
        return date;
    }

    public static Date getTaskLastDateOfTiming(TimerTask task) {
        Date date = null;
        SortedMap<Date, Long> allTiming = task.getAllDaysAndTimes();
        if (!allTiming.isEmpty()) {
            date = allTiming.lastKey();
        }
        return date;
    }

    public static TimerProject getTaskProject(TimerTask task) {
        TimerTask currentTask = task;
        while (currentTask.getParent() != null) {
            currentTask = currentTask.getParent();
        }
        return (TimerProject)currentTask;
    }

    public static List<String> getTaskPath(TimerTask task) {
        ArrayList<String> result = new ArrayList<String>();
        if (task.getParent() != null) {
            result.addAll(TimerTaskHelper.getTaskPath(task.getParent()));
            result.add(task.getName());
        } else if (((TimerProject)task).isSynchronized()) {
            result.add(task.getName().substring("#".length()));
        } else {
            result.add(task.getName());
        }
        return result;
    }

    public static Map<Date, String> getAnnotationMap(TimerTask task, Date date) {
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(date);
        beginCal.set(11, 0);
        beginCal.set(12, 0);
        beginCal.set(13, 0);
        beginCal.set(14, 0);
        Calendar endCal = (Calendar)beginCal.clone();
        endCal.add(6, 1);
        TreeMap<Date, String> annotations = new TreeMap<Date, String>();
        for (Date day : task.getAllDaysAnnotations().keySet()) {
            if (day.compareTo(beginCal.getTime()) < 0 || day.compareTo(endCal.getTime()) >= 0) continue;
            annotations.put(day, (String)task.getAllDaysAnnotations().get(day));
        }
        return annotations;
    }

    public static List<String> getAnnotation(TimerTask task, Date date) {
        ArrayList<String> annotations = new ArrayList<String>();
        Map<Date, String> annotationMap = TimerTaskHelper.getAnnotationMap(task, date);
        annotations.addAll(annotationMap.values());
        return annotations;
    }

    public static void removeAnnotation(TimerTask task, Date date) {
        Calendar beginCal = Calendar.getInstance();
        beginCal.setTime(date);
        beginCal.set(11, 0);
        beginCal.set(12, 0);
        beginCal.set(13, 0);
        beginCal.set(14, 0);
        Calendar endCal = (Calendar)beginCal.clone();
        endCal.add(6, 1);
        Iterator<Date> iterator = task.getAllDaysAnnotations().keySet().iterator();
        while (iterator.hasNext()) {
            Date day = iterator.next();
            if (day.compareTo(beginCal.getTime()) < 0 || day.compareTo(endCal.getTime()) >= 0) continue;
            iterator.remove();
        }
    }
}

