/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.SerializationUtils;
import org.chorem.jtimer.utils.DailySortedMap;

public class TimerTask
implements Cloneable,
Comparable<TimerTask>,
Serializable {
    private static final long serialVersionUID = -7590755569706702695L;
    protected int number = -1;
    protected String name;
    protected Date creationDate;
    protected boolean closed;
    protected SortedMap<Date, Long> allDaysAndTimes = new DailySortedMap<Long>();
    protected SortedMap<Date, String> allDaysAnnotations = new TreeMap<Date, String>();
    protected TimerTask parent;
    protected List<TimerTask> subTasks = new ArrayList<TimerTask>();

    public TimerTask() {
    }

    public TimerTask(String name) {
        this();
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public List<TimerTask> getSubTasks() {
        return this.subTasks;
    }

    public boolean addTask(TimerTask t) {
        t.setParent(this);
        return this.subTasks.add(t);
    }

    public void setTime(Date date, Long seconds) {
        this.allDaysAndTimes.put(date, seconds);
    }

    public long getTime(Date date) {
        long result = 0L;
        Long t = (Long)this.allDaysAndTimes.get(date);
        if (t != null) {
            result = t;
        }
        return result;
    }

    public SortedMap<Date, Long> getAllDaysAndTimes() {
        return this.allDaysAndTimes;
    }

    public void addAnnotation(Date date, String note) {
        this.allDaysAnnotations.put(date, note);
    }

    public SortedMap<Date, String> getAllDaysAnnotations() {
        return this.allDaysAnnotations;
    }

    public TimerTask getParent() {
        return this.parent;
    }

    protected void setParent(TimerTask parent) {
        if (parent == this) {
            throw new IllegalArgumentException("Parent can't be current task");
        }
        this.parent = parent;
    }

    public String toString() {
        return this.name + this.subTasks.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimerTask)) {
            return false;
        }
        TimerTask otherTask = (TimerTask)o;
        boolean equals = this.name != null && this.name.equals(otherTask.name);
        equals &= this.creationDate == null || this.creationDate.equals(otherTask.creationDate);
        equals &= ((Object)this.subTasks).equals(otherTask.subTasks);
        equals &= this.allDaysAndTimes.equals(otherTask.allDaysAndTimes);
        return equals &= this.allDaysAnnotations.equals(otherTask.allDaysAnnotations);
    }

    public TimerTask clone() {
        TimerTask task = null;
        try {
            task = (TimerTask)super.clone();
            task.name = this.name;
            task.creationDate = this.creationDate == null ? null : (Date)this.creationDate.clone();
            task.allDaysAndTimes = (DailySortedMap)SerializationUtils.clone((Serializable)((DailySortedMap)this.allDaysAndTimes));
            task.allDaysAnnotations = (TreeMap)SerializationUtils.clone((Serializable)((TreeMap)this.allDaysAnnotations));
            task.subTasks = (ArrayList)SerializationUtils.clone((Serializable)((ArrayList)this.subTasks));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Can't clone", e);
        }
        return task;
    }

    @Override
    public int compareTo(TimerTask o) {
        int result = this.getName() == null ? -1 : (o.getName() == null ? 1 : this.getName().compareTo(o.getName()));
        return result;
    }
}

