/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.jtimer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.JTimerFactory;
import org.chorem.jtimer.data.DataViolationException;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;
import org.chorem.jtimer.ui.HelpFrame;
import org.chorem.jtimer.ui.StatusBar;
import org.chorem.jtimer.ui.TimerTaskEditor;
import org.chorem.jtimer.ui.report.ReportView;
import org.chorem.jtimer.ui.systray.SystrayManager;
import org.chorem.jtimer.ui.tasks.RefreshTreeTask;
import org.chorem.jtimer.ui.tasks.RunTaskJob;
import org.chorem.jtimer.ui.treetable.ProjectsAndTasksTable;
import org.chorem.jtimer.ui.ws.SwingConnectionInformationHandler;
import org.chorem.jtimer.ws.ProjectManagement;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.View;

public class JTimer
extends SingleFrameApplication
implements TreeSelectionListener,
MouseListener {
    private static Log log = LogFactory.getLog(JTimer.class);
    protected TimerCore core;
    protected ProjectsAndTasksTable projectsAndTasksTable;
    protected SystrayManager systrayManager;
    protected ResourceMap resourceMap;
    protected boolean selectedSingleProject = false;
    protected boolean selectedSingleTask = false;
    protected boolean selectedSingleElement = false;
    protected boolean selectedSingleRunningTask = false;
    protected boolean selectedSingleStoppedTask = false;
    protected boolean selectedMultiplesProjects = false;
    protected boolean selectedMultiplesTasks = false;
    protected boolean selectedMultiplesElements = false;

    public static void main(String[] args) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting " + JTimer.class.getSimpleName() + " at " + new Date()));
        }
        JTimer.launch(JTimer.class, (String[])args);
    }

    protected void initialize(String[] args) {
        super.initialize(args);
        ApplicationContext ctxt = this.getContext();
        this.resourceMap = ctxt.getResourceMap();
        this.core = new TimerCore();
        SwingConnectionInformationHandler handler = new SwingConnectionInformationHandler(this);
        ProjectManagement managementService = JTimerFactory.getProjectManagementService();
        if (managementService != null) {
            managementService.setConnectionDataHandler(handler);
        }
        this.systrayManager = SystrayManager.getSystray(this);
        this.core.getData().addDataEventListener(this.systrayManager);
    }

    protected void startup() {
        this.getMainFrame().setJMenuBar(this.createMenuBar());
        this.show(this.createMainComponent());
    }

    protected JComponent createMainComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createToolBar(), "North");
        ProjectsAndTasksTable projectTreeTable = this.createTreeTable();
        JScrollPane scrollPaneProjectTreeTable = new JScrollPane((Component)((Object)projectTreeTable));
        panel.add((Component)scrollPaneProjectTreeTable, "Center");
        StatusBar sb = new StatusBar((Application)this, this.core.getData());
        this.core.getData().addDataEventListener(sb);
        panel.add((Component)sb, "South");
        panel.setPreferredSize(new Dimension(640, 480));
        return panel;
    }

    protected ProjectsAndTasksTable createTreeTable() {
        this.projectsAndTasksTable = new ProjectsAndTasksTable((Application)this, this.core);
        this.projectsAndTasksTable.setName("projectslist");
        this.projectsAndTasksTable.addTreeSelectionListener(this);
        this.projectsAndTasksTable.addMouseListener(this);
        this.projectsAndTasksTable.setSelectionMode(2);
        return this.projectsAndTasksTable;
    }

    protected JComponent createToolBar() {
        String[] toolbarActionNames = new String[]{"startTask", "stopTask", "newProject", "newTask"};
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        for (String actionName : toolbarActionNames) {
            JButton button = new JButton();
            button.setAction(this.getAction(actionName));
            button.setHideActionText(true);
            button.setFocusable(false);
            toolBar.add(button);
        }
        return toolBar;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        String[] fileMenuActionNames = new String[]{"quit"};
        menuBar.add(this.createMenu("fileMenu", fileMenuActionNames));
        String[] projectMenuActionNames = new String[]{"newProject", "editProject", "closeProject", "deleteProject"};
        menuBar.add(this.createMenu("projectMenu", projectMenuActionNames));
        String[] taskMenuActionNames = new String[]{"newTask", "editTask", "closeTask", "deleteTask", "---", "startTask", "stopTask", "---", "addAnnotation", "increment1Task", "increment5Task", "increment30Task", "decrement1Task", "decrement5Task", "decrement30Task", "setToZero", "mergeTasks"};
        menuBar.add(this.createMenu("taskMenu", taskMenuActionNames));
        String[] reportMenuActionNames = new String[]{"makeReport"};
        menuBar.add(this.createMenu("reportMenu", reportMenuActionNames));
        String[] optionMenuActionNames = new String[]{"isShowClosed"};
        menuBar.add(this.createMenu("optionMenu", optionMenuActionNames));
        String[] helpMenuActionNames = new String[]{"about"};
        menuBar.add(this.createMenu("helpMenu", helpMenuActionNames));
        return menuBar;
    }

    protected JMenu createMenu(String menuName, String[] actionNames) {
        JMenu menu = new JMenu();
        menu.setName(menuName);
        this.addActionToMenu(menu, actionNames);
        return menu;
    }

    protected void addActionToMenu(JComponent menu, String[] actionNames) {
        for (String actionName : actionNames) {
            JMenuItem menuItem;
            if (actionName.equals("---")) {
                menu.add(new JSeparator());
                continue;
            }
            if (actionName.startsWith("is")) {
                menuItem = new JCheckBoxMenuItem();
                menuItem.setAction(this.getAction(actionName));
                menuItem.setIcon(null);
                menu.add(menuItem);
                continue;
            }
            menuItem = new JMenuItem();
            menuItem.setAction(this.getAction(actionName));
            menuItem.setIcon(null);
            menu.add(menuItem);
        }
    }

    protected void ready() {
        boolean init = this.core.init();
        if (init) {
            this.scheduleTreeRefresh();
            this.systrayManager.install();
        } else {
            String failTitle = this.resourceMap.getString("startFail.title", new Object[0]);
            String failMessage = this.resourceMap.getString("startFail.message", new Object[0]);
            JOptionPane.showMessageDialog(this.getMainFrame(), failMessage, failTitle, 0);
            this.exit();
        }
    }

    protected void shutdown() {
        log.debug((Object)"Shutdown called");
        this.core.exit();
        super.shutdown();
    }

    protected void scheduleTreeRefresh() {
        RefreshTreeTask refreshTreeTask = new RefreshTreeTask(this.core);
        Timer timer = new Timer();
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(System.currentTimeMillis());
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        date.add(6, 1);
        timer.schedule((java.util.TimerTask)refreshTreeTask, date.getTime(), 86400000L);
    }

    protected void displayErrorMessage(String errorMessageKey) {
        String title = this.resourceMap.getString("action.invalidActionTitle", new Object[0]);
        String message = this.resourceMap.getString(errorMessageKey, new Object[0]);
        if (StringUtils.isEmpty((String)message)) {
            message = this.resourceMap.getString("action.missingErrorMessage", new Object[]{errorMessageKey});
        }
        JOptionPane.showMessageDialog(this.getMainFrame(), message, title, 0);
    }

    @Action
    public void newProject() {
        String projectName = JOptionPane.showInputDialog(this.getMainFrame(), this.resourceMap.getString("input.newProjectMessage", new Object[0]), this.resourceMap.getString("input.newProjectTitle", new Object[0]), 3);
        if (projectName != null) {
            projectName = projectName.trim();
            TimerProject p = new TimerProject(projectName);
            p.setCreationDate(new Date());
            try {
                this.core.getData().addProject(p);
            }
            catch (DataViolationException e) {
                this.displayErrorMessage(e.getExceptionKey());
            }
        }
    }

    @Action(enabledProperty="selectedSingleProject")
    public void editProject() {
        TimerProject project = this.projectsAndTasksTable.getSelectedProjects().get(0);
        String newProjectName = (String)JOptionPane.showInputDialog(this.getMainFrame(), this.resourceMap.getString("input.editProjectMessage", new Object[0]), this.resourceMap.getString("input.editProjectTitle", new Object[0]), 1, null, null, project.getName());
        if (newProjectName != null) {
            newProjectName = newProjectName.trim();
            try {
                this.core.getData().editProject(project, newProjectName);
            }
            catch (DataViolationException e) {
                this.displayErrorMessage(e.getExceptionKey());
            }
        }
    }

    @Action(enabledProperty="selectedSingleElement")
    public void newTask() {
        TimerTask selectedTask = this.projectsAndTasksTable.getSelectedElements().get(0);
        String taskName = JOptionPane.showInputDialog(this.getMainFrame(), this.resourceMap.getString("input.newTaskMessage", new Object[]{selectedTask.getName()}), this.resourceMap.getString("input.newTaskTitle", new Object[0]), 3);
        if (taskName != null) {
            taskName = taskName.trim();
            TimerTask t = new TimerTask(taskName);
            t.setCreationDate(new Date());
            try {
                this.core.getData().addTask(selectedTask, t);
            }
            catch (DataViolationException e) {
                this.displayErrorMessage(e.getExceptionKey());
            }
        }
    }

    @Action(enabledProperty="selectedSingleTask")
    public void editTask() {
        TimerTask task = this.projectsAndTasksTable.getSelectedTasks().get(0);
        TimerTaskEditor editor = new TimerTaskEditor(this, task, this.core);
        editor.setLocationByPlatform(true);
        editor.setVisible(true);
    }

    @Action(enabledProperty="selectedSingleStoppedTask")
    public Task<?, ?> startTask() {
        TimerTask task = this.projectsAndTasksTable.getSelectedTasks().get(0);
        RunTaskJob jobToRun = new RunTaskJob(this, task, this.core.getData());
        this.core.getData().startTask(task);
        return jobToRun;
    }

    public void startedTask(TimerTask task) {
        this.setSelectedSingleRunningTask(true);
        this.setSelectedSingleStoppedTask(false);
    }

    protected RunTaskJob getJobForRunningTask(TimerTask task) {
        RunTaskJob job = null;
        TaskMonitor tm = this.getContext().getTaskMonitor();
        for (Task t : tm.getTasks()) {
            TimerTask localtask = ((RunTaskJob)t).getTask();
            if (!task.equals(localtask)) continue;
            job = (RunTaskJob)t;
        }
        return job;
    }

    @Action(enabledProperty="selectedSingleRunningTask")
    public void stopTask() {
        TimerTask task = this.projectsAndTasksTable.getSelectedTasks().get(0);
        this.stopTask(task);
    }

    public void stopTask(TimerTask task) {
        RunTaskJob rtt = this.getJobForRunningTask(task);
        rtt.wantToStop();
        this.core.getData().stopTask(task);
        this.setSelectedSingleRunningTask(false);
        this.setSelectedSingleStoppedTask(true);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void closeProject() {
        TimerProject project = this.projectsAndTasksTable.getSelectedProjects().get(0);
        this.core.getData().changeProjectCloseState(project);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void closeTask() {
        TimerTask task = this.projectsAndTasksTable.getSelectedTasks().get(0);
        this.core.getData().changeTaskCloseState(task);
    }

    @Action(enabledProperty="selectedSingleProject")
    public void deleteProject() {
        int confirm;
        TimerProject project = this.projectsAndTasksTable.getSelectedProjects().get(0);
        if (project != null && (confirm = JOptionPane.showConfirmDialog(this.getMainFrame(), this.resourceMap.getString("input.deleteProjectMessage", new Object[]{project.getName()}), this.resourceMap.getString("input.deleteProjectTitle", new Object[0]), 0, 3)) == 0) {
            try {
                this.core.getData().deleteProject(project);
            }
            catch (DataViolationException e) {
                this.displayErrorMessage(e.getExceptionKey());
            }
        }
    }

    @Action(enabledProperty="selectedSingleTask")
    public void deleteTask() {
        int confirm;
        TimerTask task = this.projectsAndTasksTable.getSelectedTasks().get(0);
        if (task != null && (confirm = JOptionPane.showConfirmDialog(this.getMainFrame(), this.resourceMap.getString("input.deleteTaskMessage", new Object[]{task.getName()}), this.resourceMap.getString("input.deleteTaskTitle", new Object[0]), 0, 3)) == 0) {
            try {
                this.core.getData().deleteTask(task);
            }
            catch (DataViolationException e) {
                this.displayErrorMessage(e.getExceptionKey());
            }
        }
    }

    @Action
    public void isShowClosed(ActionEvent event) {
        JCheckBoxMenuItem source = (JCheckBoxMenuItem)event.getSource();
        this.projectsAndTasksTable.setShowClosed(source.isSelected());
    }

    @Action(enabledProperty="selectedSingleTask")
    public void increment5Task() {
        this.incrementTaskTime(300L);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void increment30Task() {
        this.incrementTaskTime(1800L);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void decrement1Task() {
        this.incrementTaskTime(-60L);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void decrement5Task() {
        this.incrementTaskTime(-300L);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void decrement30Task() {
        this.incrementTaskTime(-1800L);
    }

    @Action(enabledProperty="selectedSingleTask")
    public void increment1Task() {
        this.incrementTaskTime(60L);
    }

    protected void incrementTaskTime(long increment) {
        TimerTask selectedTask = this.projectsAndTasksTable.getSelectedTasks().get(0);
        RunTaskJob job = this.getJobForRunningTask(selectedTask);
        if (job != null) {
            job.incrementTaskTime(increment * 1000L);
        } else {
            Date now = new Date();
            long todayTime = selectedTask.getTime(now);
            long newTodayTime = todayTime + increment;
            if (newTodayTime > 0L) {
                this.core.getData().changeTaskTime(selectedTask, now, newTodayTime);
            } else {
                this.core.getData().changeTaskTime(selectedTask, now, 0L);
            }
        }
    }

    @Action(enabledProperty="selectedSingleTask")
    public void setToZero() {
        TimerTask task = this.projectsAndTasksTable.getSelectedTasks().get(0);
        this.incrementTaskTime(-task.getTime(new Date()));
    }

    @Action(enabledProperty="selectedMultiplesTasks")
    public void mergeTasks() {
        List<TimerTask> tasks = this.projectsAndTasksTable.getSelectedTasks();
        TimerTask destinationTask = tasks.get(0);
        List<TimerTask> otherTasks = tasks.subList(1, tasks.size());
        int confirm = JOptionPane.showConfirmDialog(this.getMainFrame(), this.resourceMap.getString("input.mergeTaskMessage", new Object[]{tasks.size(), destinationTask.getName()}), this.resourceMap.getString("input.mergeTaskTitle", new Object[0]), 0, 3);
        if (confirm == 0) {
            this.core.getData().mergeTasks(destinationTask, otherTasks);
        }
    }

    @Action(enabledProperty="selectedSingleTask")
    public void addAnnotation() {
        TimerTask selectedTask = this.projectsAndTasksTable.getSelectedTasks().get(0);
        String annotation = JOptionPane.showInputDialog(this.getMainFrame(), this.resourceMap.getString("input.addAnnotationMessage", new Object[]{selectedTask.getName()}), this.resourceMap.getString("input.addAnnotationTitle", new Object[0]), 3);
        if (annotation != null) {
            annotation = annotation.trim();
            this.core.getData().addAnnotation(selectedTask, new Date(), annotation);
        }
    }

    @Action
    public void makeReport() {
        ReportView view = new ReportView((Application)this, this.core);
        this.show((View)view);
    }

    @Action
    public void about() {
        HelpFrame aboutFrame = new HelpFrame((Application)this);
        this.show((View)aboutFrame);
    }

    public boolean isSelectedSingleProject() {
        return this.selectedSingleProject;
    }

    public void setSelectedSingleProject(boolean selectedSingleProject) {
        boolean oldValue = this.selectedSingleProject;
        this.selectedSingleProject = selectedSingleProject;
        this.firePropertyChange("selectedSingleProject", oldValue, selectedSingleProject);
    }

    public boolean isSelectedSingleTask() {
        return this.selectedSingleTask;
    }

    public void setSelectedSingleTask(boolean selectedSingleTask) {
        boolean oldValue = this.selectedSingleTask;
        this.selectedSingleTask = selectedSingleTask;
        this.firePropertyChange("selectedSingleTask", oldValue, selectedSingleTask);
    }

    public boolean isSelectedSingleElement() {
        return this.selectedSingleElement;
    }

    public void setSelectedSingleElement(boolean selectedSingleElement) {
        boolean oldValue = this.selectedSingleElement;
        this.selectedSingleElement = selectedSingleElement;
        this.firePropertyChange("selectedSingleElement", oldValue, selectedSingleElement);
    }

    public boolean isSelectedSingleRunningTask() {
        return this.selectedSingleRunningTask;
    }

    public void setSelectedSingleRunningTask(boolean selectedSingleRunningTask) {
        boolean oldValue = this.selectedSingleRunningTask;
        this.selectedSingleRunningTask = selectedSingleRunningTask;
        this.firePropertyChange("selectedSingleRunningTask", oldValue, selectedSingleRunningTask);
    }

    public boolean isSelectedSingleStoppedTask() {
        return this.selectedSingleStoppedTask;
    }

    public void setSelectedSingleStoppedTask(boolean selectedSingleStoppedTask) {
        boolean oldValue = this.selectedSingleStoppedTask;
        this.selectedSingleStoppedTask = selectedSingleStoppedTask;
        this.firePropertyChange("selectedSingleStoppedTask", oldValue, selectedSingleStoppedTask);
    }

    public boolean isSelectedMultiplesProjects() {
        return this.selectedMultiplesProjects;
    }

    public void setSelectedMultiplesProjects(boolean selectedMultiplesProjects) {
        boolean oldValue = this.selectedMultiplesProjects;
        this.selectedMultiplesProjects = selectedMultiplesProjects;
        this.firePropertyChange("selectedMultiplesProjects", oldValue, selectedMultiplesProjects);
    }

    public boolean isSelectedMultiplesTasks() {
        return this.selectedMultiplesTasks;
    }

    public void setSelectedMultiplesTasks(boolean selectedMultiplesTasks) {
        boolean oldValue = this.selectedMultiplesTasks;
        this.selectedMultiplesTasks = selectedMultiplesTasks;
        this.firePropertyChange("selectedMultiplesTasks", oldValue, selectedMultiplesTasks);
    }

    public boolean isSelectedMultiplesElements() {
        return this.selectedMultiplesElements;
    }

    public void setSelectedMultiplesElements(boolean selectedMultiplesElements) {
        boolean oldValue = this.selectedMultiplesElements;
        this.selectedMultiplesElements = selectedMultiplesElements;
        this.firePropertyChange("selectedMultiplesElements", oldValue, selectedMultiplesElements);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        List<TimerTask> elements = this.projectsAndTasksTable.getSelectedElements();
        List<TimerProject> projects = this.projectsAndTasksTable.getSelectedProjects();
        List<TimerTask> tasks = this.projectsAndTasksTable.getSelectedTasks();
        if (tasks.size() == 1 && projects.size() == 0) {
            TimerTask task = tasks.get(0);
            this.setSelectedSingleTask(true);
            RunTaskJob job = this.getJobForRunningTask(task);
            if (job == null || job.isStopping()) {
                this.setSelectedSingleStoppedTask(true);
                this.setSelectedSingleRunningTask(false);
            } else {
                this.setSelectedSingleStoppedTask(false);
                this.setSelectedSingleRunningTask(true);
            }
            this.setSelectedMultiplesTasks(false);
        } else {
            this.setSelectedSingleTask(false);
            this.setSelectedSingleStoppedTask(false);
            this.setSelectedSingleRunningTask(false);
            if (tasks.size() > 1) {
                this.setSelectedMultiplesTasks(projects.size() == 0);
            } else if (tasks.size() == 0) {
                this.setSelectedSingleProject(projects.size() == 1);
                this.setSelectedMultiplesProjects(projects.size() > 1);
            }
        }
        this.setSelectedSingleElement(elements.size() == 1);
        this.setSelectedMultiplesElements(elements.size() > 1);
    }

    public int askIdleOption() {
        int option;
        Object[] dialogOption = new String[]{this.resourceMap.getString("idleDetect.askOptionResume", new Object[0]), this.resourceMap.getString("idleDetect.askOptionContinue", new Object[0]), this.resourceMap.getString("idleDetect.askOptionRevert", new Object[0])};
        DateFormat formatter = DateFormat.getTimeInstance(3);
        Date idleDate = new Date();
        idleDate.setTime(System.currentTimeMillis() - JTimerFactory.getIdleTime());
        String title = this.resourceMap.getString("idleDetect.askTitle", new Object[0]);
        String message = this.resourceMap.getString("idleDetect.askMessage", new Object[]{JTimerFactory.getIdleTime() / 60000L, formatter.format(idleDate)});
        int answer = JOptionPane.showOptionDialog(this.getMainFrame(), message, title, -1, 3, null, dialogOption, dialogOption[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Answer for idle response = " + answer));
        }
        switch (answer) {
            case 0: {
                option = 2;
                break;
            }
            case 1: {
                option = 1;
                break;
            }
            default: {
                option = 0;
            }
        }
        return option;
    }

    protected javax.swing.Action getAction(String actionName) {
        return this.getContext().getActionMap().get((Object)actionName);
    }

    @Action
    public void show() {
        super.getMainFrame().setVisible(true);
        super.getMainFrame().toFront();
    }

    @Action
    public void hide() {
        super.getMainFrame().setVisible(false);
    }

    public void preIdleDetect() {
        this.systrayManager.preIdleDetect();
    }

    public void postIdleDetect() {
        this.systrayManager.postIdleDetect();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mouse clicked (" + e.getClickCount() + " clics), source = " + e.getSource().getClass().getName()));
        }
        switch (e.getButton()) {
            case 1: {
                if (e.getSource() != this.projectsAndTasksTable) break;
                if (e.getClickCount() == 2) {
                    if (this.isSelectedSingleStoppedTask()) {
                        Task<?, ?> appTask = this.startTask();
                        if (appTask == null) break;
                        this.getContext().getTaskService().execute(appTask);
                        TaskMonitor tm = this.getContext().getTaskMonitor();
                        for (Task t : tm.getTasks()) {
                            if (appTask == t) continue;
                            TimerTask ttask = ((RunTaskJob)t).getTask();
                            this.core.getData().stopTask(ttask);
                            ((RunTaskJob)t).wantToStop();
                        }
                        break;
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Non selected non running task to launch");
                    break;
                }
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Single clic on tree, do nothing");
                break;
            }
            case 3: {
                JPopupMenu menu = new JPopupMenu();
                String[] actionNames = null;
                if (this.isSelectedSingleProject()) {
                    actionNames = new String[]{"newTask", "---", "newProject", "editProject", "closeProject", "deleteProject"};
                }
                if (this.isSelectedSingleTask()) {
                    actionNames = new String[]{"startTask", "stopTask", "---", "newTask", "editTask", "closeTask", "deleteTask", "---", "addAnnotation", "increment1Task", "increment5Task", "increment30Task", "decrement1Task", "decrement5Task", "decrement30Task", "setToZero"};
                }
                if (this.isSelectedMultiplesTasks()) {
                    actionNames = new String[]{"mergeTasks"};
                }
                if (actionNames == null) break;
                this.addActionToMenu(menu, actionNames);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

