/* *##%
 * Copyright (C) 2008, 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.tasks;

import java.util.Date;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.jtimer.data.TimerCore;
import org.chorem.jtimer.data.TimerDataManager;
import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

/**
 * Task used to refresh tree at midnight.
 * 
 * @author chatellier
 * @version $Revision: 2518 $
 * 
 * Last update : $Date: 2009-05-22 13:17:51 +0200 (ven. 22 mai 2009) $
 * By : $Author: chatellier $
 */
public class RefreshTreeTask extends java.util.TimerTask {

    /** log */
    private static Log log = LogFactory.getLog(RefreshTreeTask.class);

    /** Data manager */
    protected TimerDataManager dataManager;

    /**
     * Constructor with core.
     * 
     * @param core core
     */
    public RefreshTreeTask(TimerCore core) {
        this.dataManager = core.getData();
    }

    /* (non-Javadoc)
     * @see java.util.TimerTask#run()
     */
    @Override
    public void run() {

        log.info("Refresh tree");

        List<TimerProject> projects = dataManager.getProjectsList();

        refreshTasks(projects);
    }

    /**
     * Refresh task list.
     * 
     * @param tasks tasks list
     */
    protected void refreshTasks(List<? extends TimerTask> tasks) {

        for (TimerTask task : tasks) {

            // first refresk sub tasks
            refreshTasks(task.getSubTasks());

            // fire event
            Date now = new Date();
            dataManager.changeTaskTime(task, now, task.getTime(now));
        }
    }

}
