/* *##%
 * Copyright (C) 2009 Code Lutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.chorem.jtimer.ui.report.tree;

import java.awt.Color;
import java.awt.Component;
import java.util.Set;

import javax.swing.JCheckBox;
import javax.swing.JTree;

import org.chorem.jtimer.entities.TimerProject;
import org.chorem.jtimer.entities.TimerTask;

/**
 * JCheckBox tree node cell component.
 *
 * @author chatellier
 * @version $Revision: 2607 $
 * 
 * Last update : $Date: 2009-06-18 17:19:19 +0200 (jeu. 18 juin 2009) $
 * By : $Author: echatellier $
 */
public abstract class CheckBoxTreeCellComponent extends JCheckBox {

    /** serialVersionUID */
    private static final long serialVersionUID = 2497464481840318274L;
    
    /** Parent tree. */
    protected JTree parentTree;

    /** Unchecked task set. */
    protected Set<TimerTask> uncheckedTaskSet;

    public CheckBoxTreeCellComponent(JTree parentTree,
            Set<TimerTask> uncheckedTaskList) {
        this.parentTree = parentTree;
        this.uncheckedTaskSet = uncheckedTaskList;
    }

    /**
     * Generic check box component.
     * 
     * @param tree tree
     * @param value value
     * @param selected selected
     * @param expanded expanded
     * @param leaf leaf
     * @param row row
     * @return check box component
     */
    protected Component getCheckBoxComponent(JTree tree, Object value,
            boolean selected, boolean expanded, boolean leaf, int row) {

        // if this is a task
        if (value instanceof TimerTask) {
            TimerTask task = (TimerTask) value;

            // add style in project in sync
            String taskName = task.getName();
            if (task instanceof TimerProject
                    && ((TimerProject) task).isSynchronized()) {
                taskName = taskName
                        .substring(TimerProject.SYNCHRONIZED_PROJECT_NAME_PREFIX
                                .length());
            }

            // task name should not be "null"
            this.setText(taskName);

            // add color if task is closed
            if (task.isClosed()) {
                this.setForeground(Color.GRAY);
            } else {
                this.setForeground(Color.BLACK);
            }

            // set checked ?
            if (uncheckedTaskSet.contains(task)) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
        }

        return this;
    }
}
