/**
 * *##% Callao ConvertEntry
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Entry;
import org.chorem.callao.service.dto.AccountDTO;
import org.chorem.callao.service.dto.EntryDTO;
import org.chorem.callao.service.dto.TransactionDTO;

/**
 * Transforme les objets Entry : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertEntry  extends ConvertTopiaContext {

    private static final Log log = LogFactory.getLog(ConvertEntry.class);

    private static ConvertTransaction convertTransaction = new ConvertTransaction();

    private static ConvertAccount convertAccount = new ConvertAccount();

    /**
     * Permet de transformer une entité entry en objet DTO
     * @param entry
     * @return
     */
    public EntryDTO entryEntityToDto(Entry entry)
    {
        EntryDTO entryDTO = new EntryDTO();
        entryDTO.setId(entry.getTopiaId());
        entryDTO.setDescription(entry.getDescription());
        entryDTO.setAmount(entry.getAmount());
        entryDTO.setDebit(entry.getDebit());
        entryDTO.setLettering(entry.getLettering());
        entryDTO.setDetail(entry.getDetail());
        /**
         * Converti la transaction en DTO
         */
        TransactionDTO transactionDTO = convertTransaction.transactionEntityToDto(entry.getTransaction());
        entryDTO.setTransactionDTO(transactionDTO);
        /**
         * Converti le compte en DTO
         */
        convertAccount.setTransaction(getTransaction());
        AccountDTO accountDTO = convertAccount.accountEntityToDto(entry.getAccount(),null);
        entryDTO.setAccountDTO(accountDTO);
        return entryDTO;
    }


}