/**
 * *##% Callao JournalDTO
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.dto;


/**
 * Classe DTO - représente un objet compte pour le Plan Comptable Général (PCG)
 *
 * @author Rémi Chapelet
 */
public class JournalDTO  {

    private String id; // Identifiant Topia

    private String label;

    private String prefix;

    private String description;


    public JournalDTO ()
    {
        this.id = "";
        this.label = "";
        this.prefix = "";
        this.description = "";
    }

    public JournalDTO (String id, String label,String prefix,String description)
    {
        // Initialisation pour les variables chaines de caractères / Null
        if (description == null ) {
            description = "";
        }
        this.id = id;
        this.label = label;
        this.prefix = prefix;
        this.description = description;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the label
     */
    public String getLabel() {
        return label;
    }

    /**
     * @param label the label to set
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * @return the prefix
     */
    public String getPrefix() {
        return prefix;
    }

    /**
     * @param prefix the prefix to set
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /**
     * @return the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description) {
        this.description = description;
    }


}