/**
 * *##% Callao ContextCallao
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.chorem.callao.service.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.ContextUtil;

/**
 * Configuration de Callao (chargement du context)
 * @author Rémi Chapelet
 */
public class ContextCallao extends ContextUtil {

    /** log */
    private static final Log log = LogFactory.getLog(ContextCallao.class);
    /**
     * Instance de la classe (patron singleton)
     */
    private static ContextCallao instance = null;
    /**
     * Fichier pour la configuration de la base de donnees.
     */
    private Properties FichierConfig;

    /**
     * Construit le context global.
     */
    private ContextCallao() {
        super(ContextCallao.class);
    }

    /**
     * Chargement du fichier de configuration
     */
    @Override
    protected Properties loadProperties() throws IOException,
            URISyntaxException {
        FichierConfig = FileConfigLoader.LoadFile("Callao_bdd.properties");
        return FichierConfig;
    }

    /**
     * Methode qui doit etre appelee pour chaque acces a la base de donnees.
     * Si le chargement de la configuration n'est pas deja effectuee, alors
     * il appelle la methode ContextCallao pour instancier rootcontext.
     */
    public static ContextCallao getInstance() {
        if (instance == null) {
            instance = new ContextCallao();
        }
        return instance;
    }
}
