/*
 * #%L
 * bow
 * 
 * $Id: AldyLoggedInterceptor.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/interceptor/AldyLoggedInterceptor.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.interceptor;

import java.util.Map;

import org.apache.struts2.ServletActionContext;
import org.chorem.bow.User;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.chorem.bow.BowSession;

public class AldyLoggedInterceptor extends AbstractInterceptor {
    private static final long serialVersionUID = -2411549996072421471L;
    protected String redirect;

    /**
     * @param redirect the redirect to set
     */
    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        Map<String, Object> session = ActionContext.getContext().getSession();

        BowSession bowSession = BowSession.getBowSession(session);
        User user = bowSession.getUser();
        if (user != null) {
            ServletActionContext.getResponse().sendRedirect(redirect);
            return null;
        }
        return invocation.invoke();
    }

}
