/*
 * #%L
 * bow
 * 
 * $Id: RemoveBookmarkAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/RemoveBookmarkAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.Bookmark;
import org.chorem.bow.BowUtils;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Supprime un bookmark
 *
 * @author poussin
 */
public class RemoveBookmarkAction extends BowBaseAction {
    private static final long serialVersionUID = 820566716695285561L;
    protected String bookmarkId;
    protected String searchLine;
    protected String fullTextLine;
    protected String redirectTo;

    /**
     * @return the bookmarkId
     */
    public String getBookmarkId() {
        return bookmarkId;
    }

    /**
     * @param bookmarkId the bookmarkId to set
     */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    /**
     * @return the redirectTo
     */
    public String getRedirectTo() {
        return redirectTo;
    }

    public String execute() {
        if (bookmarkId != null && !bookmarkId.isEmpty()) {
            try {
                WikittyProxy proxy = getBowProxy();
                Bookmark bookmark = proxy.restore(Bookmark.class, bookmarkId);

                if (bookmark != null) {
                    proxy.delete(bookmarkId);
                }
            } catch (Exception e) {
                log.error("Can't do action", e);
            }
        }
        redirectTo = BowUtils.redirectTo(searchLine, fullTextLine);
        return SUCCESS;
    }
}