/*
 * #%L
 * bow
 * 
 * $Id: PreferencesAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/PreferencesAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.security.NoSuchAlgorithmException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowInit;
import org.chorem.bow.Preference;
import org.chorem.bow.User;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

import static org.nuiton.i18n.I18n.n_;

/**
 * Change les preferences de l'utilisateur (coleur, password, email, ...)
 * 
 * @author poussin
 */
public class PreferencesAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = -58341106356599721L;
    protected String colors;
    protected String tagsNb;
    protected String bookmarksHomePage;
    protected String searchEngineUrlSuggestions;
    protected String searchEngineUrlResults;
    protected String email;
    protected String newPassword;
    protected String currentPassword;
    protected String confirmNewPassword;
    protected String update;
    protected List<FacetTopic> bookmarksImportDate;
    protected HttpServletRequest request;
    
    
    /**
     * @return the colors
     */
    public String getColors() {
        return colors;
    }

    /**
     * @param colors the colors to set
     */
    public void setColors(String colors) {
        this.colors = colors;
    }

    /**
     * @return the tagsNb
     */
    public String getTagsNb() {
        return tagsNb;
    }

    /**
     * @param tagsNb the tagsNb to set
     */
    public void setTagsNb(String tagsNb) {
        this.tagsNb = tagsNb;
    }

    /**
     * @return the bookmarksHomePage
     */
    public String getBookmarksHomePage() {
        return bookmarksHomePage;
    }

    /**
     * @param bookmarksHomePage the bookmarksHomePage to set
     */
    public void setBookmarksHomePage(String bookmarksHomePage) {
        this.bookmarksHomePage = bookmarksHomePage;
    }

    /**
     * @return the searchEngineUrlSuggestions
     */
    public String getSearchEngineUrlSuggestions() {
        return searchEngineUrlSuggestions;
    }

    /**
     * @param searchEngineUrlSuggestions the searchEngineUrlSuggestions to set
     */
    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        this.searchEngineUrlSuggestions = searchEngineUrlSuggestions;
    }

    /**
     * @return the searchEngineUrlResults
     */
    public String getSearchEngineUrlResults() {
        return searchEngineUrlResults;
    }

    /**
     * @param searchEngineUrlResults the searchEngineUrlResults to set
     */
    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        this.searchEngineUrlResults = searchEngineUrlResults;
    }

    /**
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * @param email the email to set
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * @return the newPassword
     */
    public String getNewPassword() {
        return newPassword;
    }

    /**
     * @param newPassword the newPassword to set
     */
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    /**
     * @return the currentPassword
     */
    public String getCurrentPassword() {
        return currentPassword;
    }

    /**
     * @param currentPassword the currentPassword to set
     */
    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    /**
     * @return the confirmNewPassword
     */
    public String getConfirmNewPassword() {
        return confirmNewPassword;
    }

    /**
     * @param confirmNewPassword the confirmNewPassword to set
     */
    public void setConfirmNewPassword(String confirmNewPassword) {
        this.confirmNewPassword = confirmNewPassword;
    }

    /**
     * @return the update
     */
    public String getUpdate() {
        return update;
    }

    /**
     * @param update the update to set
     */
    public void setUpdate(String update) {
        this.update = update;
    }

    /**
     * @return the bookmarksImportDate
     */
    public List<FacetTopic> getBookmarksImportDate() {
        return bookmarksImportDate;
    }

    /**
     * @param bookmarksImportDate the bookmarksImportDate to set
     */
    public void setBookmarksImportDate(List<FacetTopic> bookmarksImportDate) {
        this.bookmarksImportDate = bookmarksImportDate;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    protected Preference changePreference() {
        Preference preference = getBowSession().getPreference();

        preference.setColors(colors);
        if ((tagsNb != null && !tagsNb.isEmpty())) {
            preference.setTags(Integer.valueOf(tagsNb));
        }
        if (bookmarksHomePage != null && !bookmarksHomePage.isEmpty()) {
            preference.setBookmarks(Integer.valueOf(bookmarksHomePage));
        }
        preference.setSearchEngineUrlSuggestions(searchEngineUrlSuggestions);
        preference.setSearchEngineUrlResults(searchEngineUrlResults);

        return preference;
    }

    protected User changeUser(User newUser) {
	if (email != null && !email.isEmpty()) {
            newUser.setEmail(email);
        }
        if (newPassword != null && confirmNewPassword != null && currentPassword != null) {
            if (!newPassword.isEmpty() && !confirmNewPassword.isEmpty() && !currentPassword.isEmpty()) {
                if (newPassword.equals(confirmNewPassword)) {
                    currentPassword = StringUtil.encodeMD5(currentPassword);
                    if (currentPassword.equals(newUser.getPassword())) {
                        newUser.setPassword(StringUtil.encodeMD5(newPassword));
                    } else {
                        addFieldError("currentPassword", getText(n_("bow.preferences.badCurrentPassword")));
                        return null;
                    }
                }
            }
        }
        return newUser;
    }

    public String execute() {
        User user = getBowSession().getUser();

        setBookmarksImportDate(BookmarkUtils.getBookmarksByImportDate(request, user));
        if (update != null) { //If the user submitted the form
            WikittyProxy proxy = getBowProxy();
            Preference preference = changePreference();
            proxy.store(preference);

            User newUser = proxy.restore(User.class, user.getWikittyId());
            Criteria criteria = Search.query().eq(User.FQ_FIELD_USER_EMAIL, email).criteria();
            User find = proxy.findByCriteria(User.class, criteria);

            if (find == null || find.getEmail().equals(user.getEmail())) {
                if ((newUser = changeUser(newUser)) == null) {
                    return ERROR;
                }
                newUser = proxy.store(newUser);
                getBowSession().setUser(newUser);

                preference = proxy.restore(Preference.class, newUser.getWikittyId());
                getBowSession().setPreference(preference);
                return "update";
            } else {
                // this email address is already used by someone else
                setEmail(user.getEmail());
                addActionError(getText("bow.preferences.emailAldyExists"));
                return ERROR;
            }
        } else {
            // If the user didn't submit the form, the fields are filled with
            // the current preferences values
            Preference preference = getBowSession().getPreference();

            setEmail(user.getEmail());
            if (preference != null) {
                setColors(preference.getColors());
                setTagsNb(String.valueOf(preference.getTags()));
                setBookmarksHomePage(String.valueOf(preference.getBookmarks()));
                setSearchEngineUrlSuggestions(preference.getSearchEngineUrlSuggestions());
                setSearchEngineUrlResults(preference.getSearchEngineUrlResults());
            }
        }
        BowInit.initHomePage(request, user);
        return SUCCESS;
    }
}
