/*
 * #%L
 * bow
 * 
 * $Id: ModifyBookmarkAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/ModifyBookmarkAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkUtils;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Modifie une entree du bookmark
 * 
 * @author poussin
 */
public class ModifyBookmarkAction extends BowBaseAction {
    private static final long serialVersionUID = 8197008295267924063L;
    protected String link;
    protected String name;
    protected String alias;
    protected String tags;
    protected String bookmarkId;
    protected String searchLine;
    protected String fullTextLine;

    /**
     * @return the link
     */
    public String getLink() {
        return link;
    }
    
    /**
     * @param url the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }
    
    /**
     * @return the name
     */
    public String getName() {
        return name;
    }
    
    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * @return the alias
     */
    public String getAlias() {
        return alias;
    }
    
    /**
     * @param alias the alias to set
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }
    
    /**
     * @return the tags
     */
    public String getTags() {
        return tags;
    }
    
    /**
     * @param tags the tags to set
     */
    public void setTags(String tags) {
        this.tags = tags;
    }
    
    /**
     * @return the bookmarkId
     */
    public String getBookmarkId() {
        return bookmarkId;
    }
    
    /**
     * @param bookmarkId the bookmarkId to set
     */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }
    
    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    public String execute() {
	WikittyProxy proxy = getBowProxy();
        Bookmark bookmark = proxy.restore(Bookmark.class, bookmarkId);

        if (bookmark != null) {
            if (alias != null && !alias.isEmpty()) {
                Criteria criteria = Search.query().eq(Bookmark.FQ_FIELD_BOOKMARK_ALIAS, alias).criteria();

                if (proxy.findByCriteria(Bookmark.class, criteria) != null) {
                    alias = bookmark.getAlias();
                }
            }
            BookmarkUtils.updateBookmark(bookmark, name, link, tags, alias);
            proxy.store(bookmark);
        }
        return SUCCESS;
    }
}