/*
 * #%L
 * bow
 * 
 * $Id: GenerateTokenAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/GenerateTokenAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.Token;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Force la regeneration de token permanent et temporaire
 * 
 * @author poussin
 */
public class GenerateTokenAction extends BowBaseAction {

    private static final long serialVersionUID = 1141019772989666309L;

    public String execute() {
        User user = getBowSession().getUser();
        WikittyProxy proxy = getBowProxy();
        Criteria criteria = Search.query().eq(Token.FQ_FIELD_TOKEN_EMAIL, user.getEmail()).criteria();
        Token currentToken = proxy.findByCriteria(Token.class, criteria);

        if (currentToken != null) {
            String id = currentToken.getWikittyId();
            proxy.delete(id);
        }
        // on vient d'effacer le token permanent, demande le load, va en
        // regenerer un
        getBowSession().loadToken();

        return SUCCESS;
    }
}