/*
 * #%L
 * bow
 * 
 * $Id: ExportBookmarksAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/ExportBookmarksAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.interceptor.ServletResponseAware;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Export son bookmark au format HTML
 * TODO poussin 20110211 n'y aurait-il pas une meilleur facon d'envoyer un fichier
 * en struts ???
 *
 * @author poussin
 */
public class ExportBookmarksAction extends BowBaseAction implements ServletResponseAware {
    private static final long serialVersionUID = 45880214686011946L;
    protected HttpServletResponse response;

    @Override
    public void setServletResponse(HttpServletResponse response) {
	this.response = response;
    }
    
    public String execute() {
        WikittyProxy proxy = getBowProxy();
        User user = getBowSession().getUser();
        Criteria criteria = Search.query()
                .eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail()).criteria();
        List<Bookmark> bookmarks = proxy.findAllByCriteria(Bookmark.class, criteria).getAll();
        String export = BookmarkUtils.getExportHtmlBookmark(bookmarks);
        byte[] buff = export.getBytes();
        ServletOutputStream op;

        try {
            op = response.getOutputStream();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=\"bookmarks.html\"");
            response.setContentLength(buff.length);
            op.write(buff, 0, buff.length);
            op.flush();
            op.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return SUCCESS;
    }
}