/*
 * #%L
 * bow
 * 
 * $Id: EditBookmarkAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/EditBookmarkAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowInit;
import org.chorem.bow.BowSearch;
import org.chorem.bow.User;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Prepare les données pour la modification d'un bookmark
 * TODO poussin 20110211 peut-etre le remplacer par une popup JS d'edition ?
 *
 * @author poussin
 */
public class EditBookmarkAction extends BowBaseAction implements ServletRequestAware {
    private static final long serialVersionUID = 2706590901233864637L;
    protected String bookmarkId;
    protected String searchLine;
    protected String fullTextLine;
    protected HttpServletRequest request;

    /**
     * @return the bookmarkId
     */
    public String getBookmarkId() {
        return bookmarkId;
    }

    /**
     * @param bookmarkId the bookmarkId to set
     */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    @Override
    public void setServletRequest(HttpServletRequest request) {
	this.request = request;
    }
    
    public String execute() {
	if (bookmarkId != null && !bookmarkId.isEmpty()) {
            WikittyProxy proxy = getBowProxy();
            Bookmark bookmark = proxy.restore(Bookmark.class, bookmarkId);

            if (bookmark != null) {
                request.setAttribute("link", bookmark.getLink());
                request.setAttribute("name", bookmark.getDescription());
                request.setAttribute("alias", bookmark.getAlias());
                request.setAttribute("tags", BookmarkUtils.getBookmarkTagsString(bookmark));
                String servletName = BowConfig.getInstance().getServletBow();
                request.setAttribute("formAction",
                        "/" + servletName + "/modifyBookmark.action"
                        + "?bookmarkId=" + bookmarkId
                        + "&amp;searchLine=" + searchLine
                        + "&amp;fullTextLine=" + fullTextLine);
            }
        }
        User user = getBowSession().getUser();
        if (searchLine == null || searchLine.equals("")) {
            BowInit.initHomePage(request, user);
            return "home";
        } else {
            try {
                BowSearch.search(request, user);
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (ServletException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            return "search";
        }
    }
}