/*
 * #%L
 * bow
 * 
 * $Id: DeleteSearchResultsAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/DeleteSearchResultsAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.util.ArrayList;
import java.util.List;

import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.Search;

/**
 * Supprime des bookmarks qui satisfont le critere de recherche. Si fullTextLine
 * est non vide, alors elle est utilisee, pour la recherche, sinon on utilise
 * searchLine
 *
 * @author poussin
 */
public class DeleteSearchResultsAction extends BowBaseAction {
    
    private static final long serialVersionUID = -3903724044644625507L;
    protected String searchLine;
    protected String fullTextLine;

    /**
     * @return the searchLine
     */
    public String getSearchLine() {
        return searchLine;
    }

    /**
     * @param searchLine the searchLine to set
     */
    public void setSearchLine(String searchLine) {
        this.searchLine = searchLine;
    }

    /**
     * @return the fullTextLine
     */
    public String getFullTextLine() {
        return fullTextLine;
    }

    /**
     * @param fullTextLine the fullTextLine to set
     */
    public void setFullTextLine(String fullTextLine) {
        this.fullTextLine = fullTextLine;
    }

    public String execute() {
        if (searchLine != null && fullTextLine != null) {
            WikittyProxy proxy = getBowProxy();
            Criteria criteria;

            User user = getBowSession().getUser();
            if (fullTextLine.isEmpty()) {
                criteria = BookmarkUtils.getBookmarkListCriteriaByUser(user, searchLine);
            } else {
                criteria = Search.query().keyword(fullTextLine).eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail()).criteria().addFacetField(Bookmark.FQ_FIELD_BOOKMARK_TAGS);
            }
            List<Bookmark> bookmarks = proxy.findAllByCriteria(Bookmark.class, criteria).getAll();
            List<String> ids = new ArrayList<String>();

            for (Bookmark bookmark : bookmarks) {
                if (searchLine.isEmpty() && bookmark.getTags() == null || !searchLine.isEmpty()
                        || fullTextLine.isEmpty() && bookmark.getTags() == null || !fullTextLine.isEmpty()) {
                    ids.add(bookmark.getWikittyId());
                }
            }
            proxy.delete(ids);
        }
        return SUCCESS;
    }
}