/*
 * #%L
 * bow
 * 
 * $Id: DeleteImportAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/DeleteImportAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import java.util.ArrayList;
import java.util.List;

import org.chorem.bow.Bookmark;
import org.chorem.bow.Import;
import org.chorem.bow.User;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.Search;

/**
 * Supprime un import de bookmark
 *
 * FIXME poussin 20110211 la suppression devrait se faire par rapport a l'id
 * de l'import et non pas par rapport a la date :(
 *
 * @author poussin
 */
public class DeleteImportAction extends BowBaseAction {
    private static final long serialVersionUID = 8714394293884265516L;
    protected String date;
    
    /**
     * @return the date
     */
    public String getDate() {
        return date;
    }
    /**
     * @param date the date to set
     */
    public void setDate(String date) {
        this.date = date;
    }
    
    public String execute() {
        if (date != null &&
                date.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}.[0-9]{1,3}Z")) {
            WikittyProxy proxy = getBowProxy();
            User user = getBowSession().getUser();
            Criteria criteria = Search.query()
                    .eq(Element.ELT_EXTENSION, Import.EXT_IMPORT)
                    .eq(Bookmark.FQ_FIELD_BOOKMARK_EMAIL, user.getEmail())
                    .eq(Import.FQ_FIELD_IMPORT_DATE, date).criteria();
            List<Import> bookmarks = proxy.findAllByCriteria(Import.class, criteria).getAll();
            List<String> ids = new ArrayList<String>();

            for (Import bookmark : bookmarks) {
                ids.add(bookmark.getWikittyId());
            }
            proxy.delete(ids);
        }
        return SUCCESS;
    }

}