/*
 * #%L
 * bow
 * 
 * $Id: BowBaseAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/BowBaseAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.util.ValueStack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.util.List;
import java.util.Map;
import org.apache.struts2.interceptor.SessionAware;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSession;

public class BowBaseAction extends ActionSupport implements SessionAware {

    private static final long serialVersionUID = 1L;

    protected static final Log log = LogFactory.getLog(BowBaseAction.class);

    public static final String UNTRANSLATED_MARKER = "???";
    
    protected Map<String, Object> session;

    public BowSession getBowSession() {
        BowSession result = BowSession.getBowSession(session);
        return result;
    }

    public BowProxy getBowProxy() {
        BowProxy result = getBowSession().getProxy();
        return result;
    }

    @Override
    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    @Override
    public String getText(String aTextName) {
        String value = super.getText(aTextName);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String aTextName, String defaultValue) {
        String value = super.getText(aTextName, defaultValue);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String aTextName, String defaultValue, String obj) {
        String value = super.getText(aTextName, defaultValue, obj);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String aTextName, List<Object> args) {
        String value = super.getText(aTextName, args);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String key, String[] args) {
        String value = super.getText(key, args);
        return getSafeText(key, value);
    }

    @Override
    public String getText(String aTextName, String defaultValue, List<Object> args) {
        String value = super.getText(aTextName, defaultValue, args);
        return getSafeText(aTextName, value);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args) {
        String value = super.getText(key, defaultValue, args);
        return getSafeText(key, value);
    }

    @Override
    public String getText(String key, String defaultValue, List<Object> args, ValueStack stack) {
        String value = super.getText(key, defaultValue, args, stack);
        return getSafeText(key, value);
    }

    @Override
    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        String value = super.getText(key, defaultValue, args, stack);
        return getSafeText(key, value);
    }

    protected String getSafeText(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            if (log.isWarnEnabled()) {
                log.warn("Key [" + key + "] is not translated");
            }
            return UNTRANSLATED_MARKER + key + UNTRANSLATED_MARKER;
        }
        return value;
    }
}