/*
 * #%L
 * bow
 * 
 * $Id: AddClickAction.java 192 2011-02-14 14:53:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.4/src/main/java/org/chorem/bow/action/AddClickAction.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow.action;

import org.chorem.bow.Bookmark;
import org.nuiton.wikitty.WikittyProxy;

public class AddClickAction extends BowBaseAction {
    
    private static final long serialVersionUID = 8579081104294143087L;
    protected String bookmarkId;
    protected String link;

    /**
     * @return the bookmarkId
     */
    public String getBookmarkId() {
        return bookmarkId;
    }
    /**
     * @param bookmarkId the bookmarkId to set
     */
    public void setBookmarkId(String bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    /**
     * @return the link
     */
    public String getLink() {
        return link;
    }
    /**
     * @param link the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }

    public String execute() {
        String result = ERROR;
        if (bookmarkId != null && !bookmarkId.isEmpty()) {
            WikittyProxy proxy = getBowProxy();
            Bookmark bookmark = proxy.restore(Bookmark.class, bookmarkId);
            if (bookmark != null) {
                bookmark.setClick(bookmark.getClick() + 1);
                proxy.store(bookmark);
                setLink(bookmark.getLink());
                result = SUCCESS;
            }
        }
        return result;
    }
    
}