/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class UserAbstract extends BusinessEntityImpl implements User {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionUser;
    /**
     * getPassword :
     * @return String 
     */

    @Override
    public String getPassword() {
        String value = UserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    @Override
    public void setPassword(String password) {
        String oldValue = getPassword();
        UserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_PASSWORD, oldValue, getPassword());
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        String value = UserHelper.getEmail(getWikitty());
        return value;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        String oldValue = getEmail();
        UserHelper.setEmail(getWikitty(), email);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_EMAIL, oldValue, getEmail());
}

    /**
     * UserAbstract :
     */

    public UserAbstract() {
        super();
}

    /**
     * UserAbstract :
     * @param wikitty 
     */

    public UserAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * UserAbstract :
     * @param businessEntityImpl 
     */

    public UserAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionUser =
                new WikittyExtension(EXT_USER,
                                     "3.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String password unique=\"true\"", 
                                             "String email unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionUser);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //UserAbstract
