/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class BookmarkHelper {

    /**
     * BookmarkHelper :
     * utility class all provided methods are accessible the static way
     */

    private BookmarkHelper() {// empty
}

    /**
     * getLink :
     * @param wikitty 
     * @return String 
     */

    public static String getLink(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_LINK);
        return value;
}

    /**
     * setLink :
     * @param wikitty 
     * @param link 
     * @return String 
     */

    public static String setLink(Wikitty wikitty, String link) {
        String oldValue = getLink(wikitty);
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_LINK, link);
        return oldValue;
}

    /**
     * getDescription :
     * @param wikitty 
     * @return String 
     */

    public static String getDescription(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DESCRIPTION);
        return value;
}

    /**
     * setDescription :
     * @param wikitty 
     * @param description 
     * @return String 
     */

    public static String setDescription(Wikitty wikitty, String description) {
        String oldValue = getDescription(wikitty);
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DESCRIPTION, description);
        return oldValue;
}

    /**
     * getTags :
     * @param wikitty 
     * @return Set<String> 
     */

    public static Set<String> getTags(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS, String.class);
        return result;
}

    /**
     * setTags :
     * @param wikitty 
     * @param tags 
     */

    public static void setTags(Wikitty wikitty, Set<String> tags) {
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS, tags);
}

    /**
     * addAllTags :
     * @param wikitty 
     * @param tags 
     */

    public static void addAllTags(Wikitty wikitty, Set<String> tags) {
        if(tags != null){
            for (String id:tags){
                addTags(wikitty, id);
            }
        }
}

    /**
     * addTags :
     * @param wikitty 
     * @param element 
     */

    public static void addTags(Wikitty wikitty, String element) {
        wikitty.addToField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS, element);
}

    /**
     * removeTags :
     * @param wikitty 
     * @param element 
     */

    public static void removeTags(Wikitty wikitty, String element) {
        wikitty.removeFromField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS, element);
}

    /**
     * clearTags :
     * @param wikitty 
     */

    public static void clearTags(Wikitty wikitty) {
        wikitty.clearField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS);
}

    /**
     * getDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DATE);
        return value;
}

    /**
     * setDate :
     * @param wikitty 
     * @param date 
     * @return Date 
     */

    public static Date setDate(Wikitty wikitty, Date date) {
        Date oldValue = getDate(wikitty);
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DATE, date);
        return oldValue;
}

    /**
     * getEmail :
     * @param wikitty 
     * @return String 
     */

    public static String getEmail(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_EMAIL);
        return value;
}

    /**
     * setEmail :
     * @param wikitty 
     * @param email 
     * @return String 
     */

    public static String setEmail(Wikitty wikitty, String email) {
        String oldValue = getEmail(wikitty);
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_EMAIL, email);
        return oldValue;
}

    /**
     * getClick :
     * @param wikitty 
     * @return int 
     */

    public static int getClick(Wikitty wikitty) {
        int value = wikitty.getFieldAsInt(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_CLICK);
        return value;
}

    /**
     * setClick :
     * @param wikitty 
     * @param click 
     * @return int 
     */

    public static int setClick(Wikitty wikitty, int click) {
        int oldValue = getClick(wikitty);
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_CLICK, click);
        return oldValue;
}

    /**
     * getAlias :
     * @param wikitty 
     * @return String 
     */

    public static String getAlias(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_ALIAS);
        return value;
}

    /**
     * setAlias :
     * @param wikitty 
     * @param alias 
     * @return String 
     */

    public static String setAlias(Wikitty wikitty, String alias) {
        String oldValue = getAlias(wikitty);
        wikitty.setField(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_ALIAS, alias);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_LINK);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_LINK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DATE);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_EMAIL);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_CLICK);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_CLICK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_ALIAS);
            Object f2 = w2.getFieldAsObject(Bookmark.EXT_BOOKMARK, Bookmark.FIELD_BOOKMARK_ALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(Bookmark.EXT_BOOKMARK);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : BookmarkAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //BookmarkHelper
