/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public interface Bookmark extends BusinessEntity {     String EXT_BOOKMARK = "Bookmark";
     String FIELD_BOOKMARK_LINK = "link";
     String FQ_FIELD_BOOKMARK_LINK = EXT_BOOKMARK + ".link";
     String FIELD_BOOKMARK_DESCRIPTION = "description";
     String FQ_FIELD_BOOKMARK_DESCRIPTION = EXT_BOOKMARK + ".description";
     String FIELD_BOOKMARK_TAGS = "tags";
     String FQ_FIELD_BOOKMARK_TAGS = EXT_BOOKMARK + ".tags";
     String FIELD_BOOKMARK_DATE = "date";
     String FQ_FIELD_BOOKMARK_DATE = EXT_BOOKMARK + ".date";
     String FIELD_BOOKMARK_EMAIL = "email";
     String FQ_FIELD_BOOKMARK_EMAIL = EXT_BOOKMARK + ".email";
     String FIELD_BOOKMARK_CLICK = "click";
     String FQ_FIELD_BOOKMARK_CLICK = EXT_BOOKMARK + ".click";
     String FIELD_BOOKMARK_ALIAS = "alias";
     String FQ_FIELD_BOOKMARK_ALIAS = EXT_BOOKMARK + ".alias";
    /**
     * getLink :
     * @return String 
     */

     String getLink();

    /**
     * setLink :
     * @param link 
     */

     void setLink(String link);

    /**
     * getDescription :
     * @return String 
     */

     String getDescription();

    /**
     * setDescription :
     * @param description 
     */

     void setDescription(String description);

    /**
     * getTags :
     * @return Set<String> 
     */

     Set<String> getTags();

    /**
     * setTags :
     * @param tags 
     */

     void setTags(Set<String> tags);

    /**
     * addAllTags :
     * @param tags 
     */

     void addAllTags(Set<String> tags);

    /**
     * addTags :
     * @param element 
     */

     void addTags(String element);

    /**
     * removeTags :
     * @param element 
     */

     void removeTags(String element);

    /**
     * clearTags :
     */

     void clearTags();

    /**
     * getDate :
     * @return Date 
     */

     Date getDate();

    /**
     * setDate :
     * @param date 
     */

     void setDate(Date date);

    /**
     * getEmail :
     * @return String 
     */

     String getEmail();

    /**
     * setEmail :
     * @param email 
     */

     void setEmail(String email);

    /**
     * getClick :
     * @return int 
     */

     int getClick();

    /**
     * setClick :
     * @param click 
     */

     void setClick(int click);

    /**
     * getAlias :
     * @return String 
     */

     String getAlias();

    /**
     * setAlias :
     * @param alias 
     */

     void setAlias(String alias);


} //Bookmark
