/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class TokenHelper extends TokenImpl {

    private static final long serialVersionUID = -894068414L;


    /**
     * This class is not instanciable, it's just helper
     */
    private TokenHelper() {
    }


    static public void setToken(Wikitty w, String token) {
        w.setField(EXT_TOKEN, "token", token);
    }

    static public String getToken(Wikitty w) {
        String result = w.getFieldAsString(EXT_TOKEN, "token");
        return result;
    }


    static public void setEmail(Wikitty w, String email) {
        w.setField(EXT_TOKEN, "email", email);
    }

    static public String getEmail(Wikitty w) {
        String result = w.getFieldAsString(EXT_TOKEN, "email");
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_TOKEN);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TOKEN, FIELD_TOKEN);
            Object f2 = w2.getFieldAsObject(EXT_TOKEN, FIELD_TOKEN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_TOKEN, FIELD_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_TOKEN, FIELD_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //TokenHelper
