/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class PreferenceHelper extends PreferenceImpl {

    private static final long serialVersionUID = -1600571350L;


    /**
     * This class is not instanciable, it's just helper
     */
    private PreferenceHelper() {
    }


    static public void setTags(Wikitty w, int tags) {
        w.setField(EXT_PREFERENCE, "tags", tags);
    }

    static public int getTags(Wikitty w) {
        int result = w.getFieldAsInt(EXT_PREFERENCE, "tags");
        return result;
    }


    static public void setBookmarks(Wikitty w, int bookmarks) {
        w.setField(EXT_PREFERENCE, "bookmarks", bookmarks);
    }

    static public int getBookmarks(Wikitty w) {
        int result = w.getFieldAsInt(EXT_PREFERENCE, "bookmarks");
        return result;
    }


    static public void setColors(Wikitty w, String colors) {
        w.setField(EXT_PREFERENCE, "colors", colors);
    }

    static public String getColors(Wikitty w) {
        String result = w.getFieldAsString(EXT_PREFERENCE, "colors");
        return result;
    }


    static public void setSearchEngineUrlSuggestions(Wikitty w, String searchEngineUrlSuggestions) {
        w.setField(EXT_PREFERENCE, "searchEngineUrlSuggestions", searchEngineUrlSuggestions);
    }

    static public String getSearchEngineUrlSuggestions(Wikitty w) {
        String result = w.getFieldAsString(EXT_PREFERENCE, "searchEngineUrlSuggestions");
        return result;
    }


    static public void setSearchEngineUrlResults(Wikitty w, String searchEngineUrlResults) {
        w.setField(EXT_PREFERENCE, "searchEngineUrlResults", searchEngineUrlResults);
    }

    static public String getSearchEngineUrlResults(Wikitty w) {
        String result = w.getFieldAsString(EXT_PREFERENCE, "searchEngineUrlResults");
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_PREFERENCE);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_TAGS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_BOOKMARKS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_BOOKMARKS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_COLORS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_COLORS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLSUGGESTIONS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLSUGGESTIONS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLRESULTS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLRESULTS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //PreferenceHelper
