/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class ImportAbstract extends BusinessEntityWikitty implements Import {

    private static final long serialVersionUID = -1646697675L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionImport =
        new WikittyExtension(EXT_IMPORT, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"Date date"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionImport);

        extensions = Collections.unmodifiableList(exts);
    }

	public ImportAbstract() {
		super();
	}

    public ImportAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public ImportAbstract(Wikitty wi) {
		super(wi);
	}


    public void setDate(Date date) {
        Object oldValue = getField(EXT_IMPORT, "date");
        getWikitty().setField(EXT_IMPORT, "date", date);
        getPropertyChangeSupport().firePropertyChange("date", oldValue, date);
    }

    public Date getDate() {
        Date result = getWikitty().getFieldAsDate(EXT_IMPORT, "date");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_IMPORT, FIELD_DATE);
            Object f2 = w2.getFieldAsObject(EXT_IMPORT, FIELD_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //ImportAbstract
