/*
 * #%L
 * bow
 * 
 * $Id: BowProxy.java 144 2010-12-23 10:24:48Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.3/src/main/java/org/chorem/bow/BowProxy.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.Arrays;
import java.util.List;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.jdbc.WikittyServiceJDBC;

/**
 * Proxy pour utiliser les wikitty convenablement initialise.
 *
 * @author poussin
 * @version $Revision: 144 $
 *
 * Last update: $Date: 2010-12-23 11:24:48 +0100 (jeu., 23 déc. 2010) $
 * by : $Author: bpoussin $
 */
public class BowProxy extends WikittyProxy {

    static protected BowProxy instance;

    synchronized static public BowProxy getInstance() {
        if (instance == null) {
            BowConfig config = BowConfig.getInstance();
            instance = new BowProxy(config);
            /*
             * Fixe me when wikitty will integrate this function
             */
            WikittyExtensionMigration.migrationRegistry.put(User.EXT_USER, new UserMigration());
        }
        return instance;
    }

    protected BowProxy(BowConfig config) {
        List<WikittyExtension> extensions = Arrays.asList(
                UserImpl.extensionUser,
                PreferenceImpl.extensionPreference,
                BookmarkImpl.extensionBookmark,
                TokenImpl.extensionToken);
        WikittyService ws = new WikittyServiceJDBC(config.getFlatOptions());
        ws = new WikittyServiceCached(ws);
        String token = getSecurityToken();
        ws.storeExtension(token, extensions);
        setWikittyService(ws);
    }
}
