/*
 * #%L
 * bow
 * 
 * $Id: BowConfig.java 144 2010-12-23 10:24:48Z bpoussin $
 * $HeadURL: http://svn.chorem.org/svn/bow/tags/bow-0.3/src/main/java/org/chorem/bow/BowConfig.java $
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import static org.nuiton.i18n.I18n._;

import java.io.File;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;

/**
 *
 * @author poussin
 * @version $Revision: 144 $
 *
 * Last update: $Date: 2010-12-23 11:24:48 +0100 (jeu., 23 déc. 2010) $
 * by : $Author: bpoussin $
 */
public class BowConfig extends ApplicationConfig {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(BowConfig.class);
    /** Singleton instance. */
    protected static BowConfig instance;

    public BowConfig() {

        // set default option (included configuration file name : important)
        for (Option o : Option.values()) {
            if (o.defaultValue != null) {
                setDefaultOption(o.key, o.defaultValue);
            }
        }
    }

    public static synchronized BowConfig getInstance() {
        if (instance == null) {
            try {
                instance = new BowConfig();
                instance.parse(StringUtil.EMPTY_STRING_ARRAY);
                instance.setDataDirInSystemProps();
            } catch (Exception e) {
                throw new UnhandledException(e);
            }
        }
        return instance;
    }

    /**
     * Get version as string.
     *
     * @return version
     */
    public String getVersion() {
        return getOption(Option.APPLICATION_VERSION.key);
    }

    /**
     * Get bow url as string.
     *
     * @return url
     */
    public String getBowUrl() {
        String result = getOption(Option.BOW_URL.key);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get alias url as string.
     *
     * @return url
     */
    public String getAliasUrl() {
        String result = getOption(Option.ALIAS_URL.key);
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    /**
     * Get bow servlet as string.
     *
     * @return servlet name
     */
    public String getServletBow() {
        return getOption(Option.SERVLET_BOW.key);
    }

    /**
     * Get alias servlet as string.
     *
     * @return servlet name
     */
    public String getServletAlias() {
        return getOption(Option.SERVLET_ALIAS.key);
    }

    /**
     * Get alias servlet url as string.
     *
     * @return servlet name
     */
    public String getServletAliasUrl() {
        String result = getAliasUrl() + getServletAlias();
        if (result != null && result.charAt(result.length() - 1) != '/') {
            result += '/';
        }
        return result;
    }

    public File getDataDirAsFile() {
        File option = getOptionAsFile(Option.DATA_DIR.key);
        return option;
    }

    /**
     * Get bow smtp server as string.
     *
     * @return smtpServer
     */
    public String getSmtpServer() {
        return getOption(Option.BOW_SMTPSERVER.key);
    }

    /**
     * Get default search engine
     *
     * @return search engine url
     */
    public String getSearchEngine() {
        return getOption(Option.SEARCH_ENGINE.key);
    }

    /**
     * Get bow address from as string.
     *
     * @return addressFrom
     */
    public String getAddressFrom() {
        return getOption(Option.BOW_ADDRESSFROM.key);
    }

    public String[] getAdmins() {
        String str = getOption(Option.BOW_ADMINS.key);
        return StringUtil.split(str, ",");
    }

    /**
     * Set {@code solr} and {@code jms} system configuration.
     *
     * This is the "only" way to configure embedded solr.
     */
    protected void setDataDirInSystemProps() {
        String value = System.getProperty(Option.DATA_DIR.key, null);
        if (value == null) {
            value = getOption(Option.DATA_DIR.key);
            if (log.isInfoEnabled()) {
                log.info("Setting system property " + Option.DATA_DIR.key + " : " + value);
            }
            System.setProperty(Option.DATA_DIR.key, value);
            env.put(Option.DATA_DIR.key, value);
        }
    }

    /**
     * Vradi option definition.
     */
    public enum Option {

        CONFIG_FILE(CONFIG_FILE_NAME, _("bow.config.configFileName.description"),
        "bow.properties", String.class, false, false),
        APPLICATION_VERSION("application.version", _("bow.config.application.version.description"),
        null, String.class, true, true),
        BOW_URL("bow.url", _("bow.config.bow.url.description"),
        null, String.class, false, false),
        ALIAS_URL("alias.url", _("bow.config.alias.url.description"),
        null, String.class, false, false),
        SERVLET_BOW("servlet.bow", _("bow.config.servlet.bow.description"),
        null, String.class, false, false),
        SERVLET_ALIAS("servlet.alias", _("bow.config.servlet.bow.description"),
        null, String.class, false, false),
        SEARCH_ENGINE("search.engine", _("bow.config.search.engine.description"),
        null, String.class, false, false),
        BOW_SMTPSERVER("bow.smtpServer", _("bow.config.bow.smtpServer.description"),
        null, String.class, false, false),
        BOW_ADDRESSFROM("bow.addressFrom", _("bow.config.bow.addressFrom.description"),
        null, String.class, false, false),
        BOW_ADMINS("bow.admins", _("bow.config.bow.admins.description"),
        null, String.class, false, false),
        DATA_DIR("solr.data.dir", _("bow.config.data.dir.description"),
        System.getProperty("user.home") + "/.bow/solr", String.class, false, false);
        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean isTransient;
        public final boolean isFinal;

        Option(String key, String description, String defaultValue,
                Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }
    }
}
