/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public class BookmarkHelper extends BookmarkImpl {

    private static final long serialVersionUID = -154257520L;


    /**
     * This class is not instanciable, it's just helper
     */
    private BookmarkHelper() {
    }


    static public void setLink(Wikitty w, String link) {
        w.setField(EXT_BOOKMARK, "link", link);
    }

    static public String getLink(Wikitty w) {
        String result = w.getFieldAsString(EXT_BOOKMARK, "link");
        return result;
    }


    static public void setDescription(Wikitty w, String description) {
        w.setField(EXT_BOOKMARK, "description", description);
    }

    static public String getDescription(Wikitty w) {
        String result = w.getFieldAsString(EXT_BOOKMARK, "description");
        return result;
    }

    static public Set<String> getTags(Wikitty w) {
        Set<String> result = w.getFieldAsSet(EXT_BOOKMARK, "tags", String.class);
        return result;
    }

    static public void addTags(Wikitty w, String element) {
        w.addToField(EXT_BOOKMARK, "tags", element);
    }
    
    static public void removeTags(Wikitty w, String element) {
        w.removeFromField(EXT_BOOKMARK, "tags", element);
    }
    
    static public void clearTags(Wikitty w) {
        w.clearField(EXT_BOOKMARK, "tags");
    }


    static public void setDate(Wikitty w, Date date) {
        w.setField(EXT_BOOKMARK, "date", date);
    }

    static public Date getDate(Wikitty w) {
        Date result = w.getFieldAsDate(EXT_BOOKMARK, "date");
        return result;
    }


    static public void setEmail(Wikitty w, String email) {
        w.setField(EXT_BOOKMARK, "email", email);
    }

    static public String getEmail(Wikitty w) {
        String result = w.getFieldAsString(EXT_BOOKMARK, "email");
        return result;
    }


    static public void setClick(Wikitty w, int click) {
        w.setField(EXT_BOOKMARK, "click", click);
    }

    static public int getClick(Wikitty w) {
        int result = w.getFieldAsInt(EXT_BOOKMARK, "click");
        return result;
    }


    static public void setAlias(Wikitty w, String alias) {
        w.setField(EXT_BOOKMARK, "alias", alias);
    }

    static public String getAlias(Wikitty w) {
        String result = w.getFieldAsString(EXT_BOOKMARK, "alias");
        return result;
    }


    /**
     * Check if wikitty has current extension
     */
    static public boolean isExtension(Wikitty w) {
        boolean result = w.hasExtension(EXT_BOOKMARK);
        return result;
    }

    /**
     * ajout les extensions static de cette classe au wikitty en argument
     */
    static public void addExtension(Wikitty w) {
        for (WikittyExtension ext : extensions) {
            w.addExtension(ext);
        }
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_LINK);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_LINK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_TAGS);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_DATE);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_CLICK);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_CLICK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_ALIAS);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_ALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //BookmarkHelper
