/*
 * #%L
 * bow
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class BookmarkAbstract extends BusinessEntityWikitty implements Bookmark {

    private static final long serialVersionUID = -154257520L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionBookmark =
        new WikittyExtension(EXT_BOOKMARK, "2.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String link",
				"String description",
				"String tags[0-*] unique=true",
				"Date date",
				"String email",
				"Numeric click",
				"String alias"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionBookmark);

        extensions = Collections.unmodifiableList(exts);
    }

	public BookmarkAbstract() {
		super();
	}

    public BookmarkAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public BookmarkAbstract(Wikitty wi) {
		super(wi);
	}


    public void setLink(String link) {
        Object oldValue = getField(EXT_BOOKMARK, "link");
        getWikitty().setField(EXT_BOOKMARK, "link", link);
        getPropertyChangeSupport().firePropertyChange("link", oldValue, link);
    }

    public String getLink() {
        String result = getWikitty().getFieldAsString(EXT_BOOKMARK, "link");
        return result;
    }


    public void setDescription(String description) {
        Object oldValue = getField(EXT_BOOKMARK, "description");
        getWikitty().setField(EXT_BOOKMARK, "description", description);
        getPropertyChangeSupport().firePropertyChange("description", oldValue, description);
    }

    public String getDescription() {
        String result = getWikitty().getFieldAsString(EXT_BOOKMARK, "description");
        return result;
    }

    public Set<String> getTags() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_BOOKMARK, "tags", String.class);
        return result;
    }

    public void addTags(String element) {
        getWikitty().addToField(EXT_BOOKMARK, "tags", element);
        getPropertyChangeSupport().firePropertyChange("tags", null, getTags());
    }
    
    public void removeTags(String element) {
        getWikitty().removeFromField(EXT_BOOKMARK, "tags", element);
        getPropertyChangeSupport().firePropertyChange("tags", null, getTags());
    }
    
    public void clearTags() {
        getWikitty().clearField(EXT_BOOKMARK, "tags");
        getPropertyChangeSupport().firePropertyChange("tags", null, getTags());
    }


    public void setDate(Date date) {
        Object oldValue = getField(EXT_BOOKMARK, "date");
        getWikitty().setField(EXT_BOOKMARK, "date", date);
        getPropertyChangeSupport().firePropertyChange("date", oldValue, date);
    }

    public Date getDate() {
        Date result = getWikitty().getFieldAsDate(EXT_BOOKMARK, "date");
        return result;
    }


    public void setEmail(String email) {
        Object oldValue = getField(EXT_BOOKMARK, "email");
        getWikitty().setField(EXT_BOOKMARK, "email", email);
        getPropertyChangeSupport().firePropertyChange("email", oldValue, email);
    }

    public String getEmail() {
        String result = getWikitty().getFieldAsString(EXT_BOOKMARK, "email");
        return result;
    }


    public void setClick(int click) {
        Object oldValue = getField(EXT_BOOKMARK, "click");
        getWikitty().setField(EXT_BOOKMARK, "click", click);
        getPropertyChangeSupport().firePropertyChange("click", oldValue, click);
    }

    public int getClick() {
        int result = getWikitty().getFieldAsInt(EXT_BOOKMARK, "click");
        return result;
    }


    public void setAlias(String alias) {
        Object oldValue = getField(EXT_BOOKMARK, "alias");
        getWikitty().setField(EXT_BOOKMARK, "alias", alias);
        getPropertyChangeSupport().firePropertyChange("alias", oldValue, alias);
    }

    public String getAlias() {
        String result = getWikitty().getFieldAsString(EXT_BOOKMARK, "alias");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_LINK);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_LINK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_DESCRIPTION);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_DESCRIPTION);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_TAGS);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_DATE);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_EMAIL);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_EMAIL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_CLICK);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_CLICK);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_BOOKMARK, FIELD_ALIAS);
            Object f2 = w2.getFieldAsObject(EXT_BOOKMARK, FIELD_ALIAS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //BookmarkAbstract
