<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@page import="org.chorem.bow.BookmarkActions" %>
<%@page import="java.text.SimpleDateFormat" %>
<%@page import="java.util.Iterator" %>
<%@page import="java.util.Set" %>
<%@page import="java.util.ArrayList" %>
<%@page import="java.util.List" %>
<%@page import="org.chorem.bow.TokenActions" %>
<%@page import="org.nuiton.wikitty.FacetTopic" %>
<%@page import="org.chorem.bow.Bookmark" %>
<%@page import="org.chorem.bow.Preference" %>


<%
            TokenActions tokenActions = (TokenActions) session.getAttribute("tokenActions");
            BookmarkActions bookmarkActions = (BookmarkActions) request.getAttribute("bookmarkActions");
            Boolean admin = (Boolean) session.getAttribute("admin");
            if (admin == null) {
                admin = false;
            }
            if (tokenActions != null && bookmarkActions != null) {
                String temporaryToken = tokenActions.getTemporaryToken();
                String permanentToken = tokenActions.getPermanentToken();
                String url = (String) request.getAttribute("bowUrl");
                int nbTags = 100;
                int nbBookmarks = 10;
                Preference preference = (Preference) session.getAttribute("preference");
                if (preference != null) {
                    if (preference.getBookmarks() > 0) {
                        nbBookmarks = preference.getBookmarks();
                    }
                    if (preference.getTags() > 0) {
                        nbTags = preference.getTags();
                    }
                }
                request.setAttribute("nbTags", nbTags);
                String formLink = (String) request.getAttribute("link");
                String formName = (String) request.getAttribute("name");
                String formTags = (String) request.getAttribute("tags");
                String formAlias = (String) request.getAttribute("alias");
                String formAction = (String) request.getAttribute("action");

                if (formLink == null) {
                    formLink = "URL";
                }
                if (formName == null) {
                    formName = "name";
                }
                if (formTags == null) {
                    formTags = "tag1 tag2...";
                }
                if (formAlias == null) {
                    formAlias = "alias";
                }
                if (formAction == null) {
                    formAction = "bow?action=addUrl";
                }
%>
<body>
    <div id="headback">
        <div id="head">
            <div id="headleft">
                <a class="logo" href="<%=url%>?action=home">bow</a>(Bookmarks On the Web)
            </div>
            <div id="headright">
                <form action="bow?action=logout">
                    <button>Logout</button>
                </form>
                <a href="#">Aide</a>
            </div>
        </div>
    </div>

    <div id="mainbodyback" class="clearfix">
        <div id="mainbody">
            <div id="content">

                <div class="menu clearfix">
                    <p>The most used bookmarks</p>
                </div>
                <div id="contenu">
                    <%
                                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                                    List<Bookmark> bookmarkList = bookmarkActions.getBookmarks();
                                    if (!bookmarkList.isEmpty()) {
                                        int count = 0;
                                        for (Bookmark bookmark : bookmarkList) {
                                            request.setAttribute("bookmark", bookmark);
                                            request.setAttribute("sdf", sdf);
                    %>
                    <jsp:include page="bookmark.jsp" flush="true" />
                    <%
                                                                ++count;
                                                                if (count >= nbBookmarks) {
                                                                    break;
                                                                }
                                                            }
                                                        } else {
                    %>
                    <h2>No Bookmarks</h2>
                    <%                                            }
                    %>
                </div>
                <div class="menu clearfix">
                    <p>The last addition bookmarks</p>
                </div>
                <div id="contenu">

                    <%
                                    List<Bookmark> lastBookmarks = bookmarkActions.getLastBookmarks();
                                    if (!lastBookmarks.isEmpty()) {
                                        int count = 0;
                                        for (Bookmark bookmark : lastBookmarks) {
                                            request.setAttribute("bookmark", bookmark);
                                            request.setAttribute("sdf", sdf);
                    %>
                    <jsp:include page="bookmark.jsp" flush="true" />
                    <%
                                                                ++count;
                                                                if (count >= nbBookmarks) {
                                                                    break;
                                                                }
                                                            }
                                                        } else {
                    %>
                    <h2>No Bookmarks</h2>
                    <%                                            }
                    %>
                </div>
            </div>
            <div id="colonneD">
                <ul class="droite">
                    <%if (admin == true) {%>
                    <li><a href="bow?action=admin">Admin</a></li>
                    <%}%>
                    <li><a href="bow?action=preferences">Preferences</a></li>
                    <li><a title="Add this link to your favourites to bookmark others in the future. This link is just available while you are connected on the site!" href="javascript:var%20url=location.href;var%20nameAndTags=prompt('Entrez%20le%20nom%20du%20lien%20et%20la%20liste%20des%20tags%20sous%20la%20forme:%20name|tag1%20tag2%20tag3',%20document.title+'|');if%20(nameAndTags!=(document.title+'|')){var%20link='<%=url%>bow?action=addUrl&token=<%=temporaryToken%>&url='+encodeURIComponent(url)+'&nameAndTags='+encodeURIComponent(nameAndTags);var%20script=document.createElement('script');script.src=link;script.type='text/javascript';document.body.appendChild(script);}void(0);">Bookmark add link (session)</a></li>
                    <li><a title="Add this link to your favourites to bookmark others in the future. This link is always available!" href="javascript:var%20url=location.href;var%20nameAndTags=prompt('Entrez%20le%20nom%20du%20lien%20et%20la%20liste%20des%20tags%20sous%20la%20forme:%20name|tag1%20tag2%20tag3',%20document.title+'|');if%20(nameAndTags!=(document.title+'|')){var%20link='<%=url%>bow?action=addUrl&token=<%=permanentToken%>&url='+encodeURIComponent(url)+'&nameAndTags='+encodeURIComponent(nameAndTags);var%20script=document.createElement('script');script.src=link;script.type='text/javascript';document.body.appendChild(script);}void(0);">Bookmark add link (permanent)</a></li>
                </ul>
                <div id="nuage">
                    <jsp:include page="tagsCloud.jsp" flush="true" />
                </div>
                <div id="recherche">
                    <h2>Search</h2>
                    <form method="POST" action="bow?action=search">
                        <div class="input">
                            <input type="text" name="searchLine"/>
                            <button>Find</button>
                        </div>
                    </form>
                </div>
                <div id="recherche">
                    <h2>Full text search</h2>
                    <form method="POST" action="bow?action=fullText">
                        <div class="input">
                            <input type="text" name="fullTextLine" value="<%=bookmarkActions.getFullTextLine()%>" />
                            <button>Find</button>
                        </div>
                    </form>
                </div>
                <div id="import">
                    <h2>Import Bookmarks</h2>
                    <form method="POST" action="bow?action=importBookmarks" enctype="multipart/form-data">
                        <div class="input">
                            <input type="file" name="upfile" size="15%"/>
                            <br/>
                            <button type="submit">Import</button>
                        </div>
                    </form>
                    <a href="bow?action=exportBookmarks">Export bookmarks</a>
                </div>
                <div id="add">
                    <h2>Add / Modify</h2>
                    <form id="bookmarkForm" method="POST" action="<%=formAction%>">
                        <div class="input"><label>URL</label><input type="text" name="url" value="<%=formLink%>" /></div>
                        <div class="input"><label>ALIAS</label><input type="text" name="alias" value="<%=formAlias%>" /></div>
                        <div class="input"><label>DESC</label><input type="text" name="name" value="<%=formName%>" /></div>
                        <div class="input"><label>TAGS</label><input type="text" name="tags" value="<%=formTags%>" /></div>
                        <button>Save</button>
                    </form>
                </div>
                <div class="colonnebas"></div>
            </div>

        </div>

    </div>
</body>
<%}%>
