/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.chorem.bow.Bookmark;
import org.chorem.bow.SuggestionsComparator;
import org.nuiton.wikitty.FacetTopic;

public class OpenSearchActions {
    protected List<Bookmark> bookmarkList = new ArrayList();
    protected List<FacetTopic> suggestions = new ArrayList();
    protected String[] search = null;

    public void findSuggestions(List<String> searchLine) {
        int size = searchLine.size();
        this.search = searchLine.toArray(new String[size]);
        String word = this.search[size - 1];
        ArrayList save = new ArrayList(this.suggestions);
        for (FacetTopic topic : save) {
            String tag = topic.getTopicName();
            if (tag == null || tag.indexOf(word) == 0 && !searchLine.contains(tag)) continue;
            this.suggestions.remove(topic);
        }
        ArrayList cpy = new ArrayList(this.bookmarkList);
        for (Bookmark bookmark : cpy) {
            Set tags = bookmark.getTags();
            boolean delete = true;
            for (FacetTopic topic : this.suggestions) {
                String name = topic.getTopicName();
                if (tags == null || !tags.contains(name)) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            this.bookmarkList.remove(bookmark);
        }
        Collections.sort(this.suggestions, new SuggestionsComparator());
    }

    protected boolean bookmarkHasTag(Bookmark bookmark, String tag) {
        Set tagList = bookmark.getTags();
        return tagList != null && tagList.contains(tag);
    }

    public void setBookmarkList(List<Bookmark> bookmarks) {
        if (bookmarks != null) {
            ArrayList<Bookmark> newList;
            this.bookmarkList = newList = new ArrayList<Bookmark>(bookmarks);
        }
    }

    public String getJsonResult() {
        String str = "[";
        str = str + "\"" + StringUtils.join((Object[])this.search, (char)' ') + "\",";
        str = str + this.getJsonSuggestions();
        str = str + ",";
        str = str + this.getJsonDescription();
        str = str + "]";
        return str;
    }

    public String getJsonSuggestions() {
        String str = "[";
        String srch = "";
        Iterator it = this.suggestions.iterator();
        if (this.search.length > 1) {
            srch = StringUtils.join((Object[])this.search, (char)' ', (int)0, (int)(this.search.length - 1));
            srch = srch + " ";
        }
        while (it.hasNext()) {
            FacetTopic su = (FacetTopic)it.next();
            str = str + "\"" + srch + su.getTopicName() + "\"";
            if (!it.hasNext()) continue;
            str = str + ",";
        }
        if (this.bookmarkList.size() <= 5 && this.suggestions.size() > 0) {
            for (Bookmark bookmark : this.bookmarkList) {
                str = str + ",\"" + bookmark.getLink() + "\"";
            }
        }
        str = str + "]";
        return str;
    }

    public String getJsonDescription() {
        String str = "[";
        Iterator it = this.suggestions.iterator();
        while (it.hasNext()) {
            FacetTopic su = (FacetTopic)it.next();
            str = str + "\"" + su.getCount() + " results\"";
            if (!it.hasNext()) continue;
            str = str + ",";
        }
        str = str + "]";
        return str;
    }

    public void setSearch(String[] tab) {
        this.search = tab;
    }

    public void setSuggestionList(List<FacetTopic> list) {
        if (list != null) {
            this.suggestions = new ArrayList<FacetTopic>(list);
        }
    }

    public List<Bookmark> getBookmarkList() {
        return this.bookmarkList;
    }

    public String[] getSearch() {
        return this.search;
    }

    public List<FacetTopic> getSuggestionList() {
        return this.suggestions;
    }
}

