/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkActions;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowProxy;
import org.chorem.bow.OpenSearchActions;
import org.chorem.bow.Preference;
import org.chorem.bow.Token;
import org.chorem.bow.TokenActions;
import org.chorem.bow.TokenImpl;
import org.chorem.bow.User;
import org.chorem.bow.UserImpl;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.search.Search;

public class ControllerServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ControllerServlet.class);
    protected String version = "";
    protected String bowServletUrl = "";

    public ControllerServlet() throws ArgumentsParserException, Exception {
        BowConfig config = BowConfig.getInstance();
        this.version = config.getVersion();
        this.bowServletUrl = config.getBowUrl();
        if (this.bowServletUrl == null) {
            throw new Exception("No bow.url=\"SERVER URL\" in bow.properties");
        }
        this.bowServletUrl = this.bowServletUrl + config.getServletBow();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String action;
            request.setAttribute("version", (Object)this.version);
            request.setAttribute("bowUrl", (Object)this.bowServletUrl);
            HttpSession session = request.getSession(true);
            User user = (User)session.getAttribute("user");
            String token = request.getParameter("token");
            if (token != null && !token.isEmpty()) {
                user = this.checkToken(token, session);
            }
            if ((action = request.getParameter("action")) != null) {
                if (action.equals("register")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionRegister");
                    }
                    this.actionRegister(request, response, session);
                } else if (action.equals("registration")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to Register");
                    }
                    request.getRequestDispatcher("register.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("forgotPassword")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to forgotPassword");
                    }
                    request.getRequestDispatcher("forgotPassword.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("login")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionLogin");
                    }
                    this.actionLogin(request, response, session);
                } else if (action.equals("logout")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionLogout");
                    }
                    this.actionLogout(request, response, session);
                } else if (action.equals("home") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionHome.jsp");
                    }
                    this.actionHome(request, user);
                    request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("addUrl") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionAddUrl");
                    }
                    this.actionAddUrl(request, response, user);
                } else if (action.equals("sendPassword")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionSendPassword");
                    }
                    this.actionSendPassword(request, response);
                } else if (action.equals("modifyBookmark") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionModif");
                    }
                    this.actionModifyBookmark(request, response, user);
                } else if (action.equals("importBookmarks") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionImportBookmarks");
                    }
                    this.actionImportBookmarks(request, response, user);
                } else if (action.equals("exportBookmarks") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionExportBookmarks");
                    }
                    this.actionExportBookmarks(response, user);
                } else if (action.equals("search") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionSearch");
                    }
                    this.actionSearch(request, user);
                    request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("generateToken") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionGenerateToken");
                    }
                    this.actionGenerateToken(request, response, user, session);
                    request.getRequestDispatcher("preferences.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("deleteTag") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionDeleteTag");
                    }
                    this.actionDeleteTag(request, response, user);
                } else if (action.equals("addAlias") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionAddAlias");
                    }
                    this.actionAddAlias(request, response);
                } else if (action.equals("removeBookmark") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionRemoveBookmark");
                    }
                    this.actionRemoveBookmark(request, response, user);
                } else if (action.equals("editBookmark") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionEditBookmark");
                    }
                    this.actionEditBookmark(request, response, user);
                } else if (action.equals("order") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionOrder");
                    }
                    this.actionOrder(request, response, user);
                    request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("addClick") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionAddClic");
                    }
                    this.actionAddClick(request, response);
                } else if (action.equals("temporaryXml")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to temporaryXml.jsp");
                    }
                    request.getRequestDispatcher("temporaryXml.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("permanentXml")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to permanentXml.jsp");
                    }
                    request.getRequestDispatcher("permanentXml.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("openSearchSuggestion") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionOpenSearchSuggestion");
                    }
                    this.actionOpenSearchSuggestion(request, response, user);
                    request.getRequestDispatcher("suggestions.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("openSearchResult") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionOpenSearchResult");
                    }
                    this.actionOpenSearchResult(request, response, session, user, token);
                } else if (action.equals("fullText") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionFullText");
                    }
                    this.actionFullText(request, user);
                    request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("preferences") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionPreferences");
                    }
                    request.getRequestDispatcher("preferences.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("admin") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionAdmin");
                    }
                    request.getRequestDispatcher("admin.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("changePreferences") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionChangePreferences");
                    }
                    this.actionChangePreferences(request, session, user);
                    request.getRequestDispatcher("preferences.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (action.equals("reIndexation") && user != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Going to actionReIndexation");
                    }
                    this.actionReIndexation(request, session, user);
                    request.getRequestDispatcher("admin.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else if (user != null) {
                    request.getRequestDispatcher("error.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    request.getRequestDispatcher("login.jsp").forward((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                request.getRequestDispatcher("login.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception eee) {
            log.error((Object)"Can't do action", (Throwable)eee);
            request.getRequestDispatcher("error.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void actionOpenSearchResult(HttpServletRequest request, HttpServletResponse response, HttpSession session, User user, String token) throws IOException, ServletException, NoSuchAlgorithmException {
        String searchLine = request.getParameter("searchLine");
        if (searchLine != null && searchLine.matches("^http://[^ ]*") && !searchLine.contains(" ")) {
            response.sendRedirect(searchLine);
        } else {
            session.setAttribute("user", (Object)user);
            this.initializeToken(session, user);
            BowProxy proxy = BowProxy.getInstance();
            Criteria criteria = this.getBookmarkListCriteriaByUser(user, searchLine);
            criteria = criteria.addSortDescending("Bookmark.click");
            PagedResult result = proxy.findAllByCriteria(Bookmark.class, criteria);
            BookmarkActions bookmarkActions = this.createBookmarkActions(request, result, searchLine);
            request.setAttribute("bookmarkActions", (Object)bookmarkActions);
            request.setAttribute("token", (Object)token);
            request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void actionOpenSearchSuggestion(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, ServletException {
        String search;
        if (user != null && (search = request.getParameter("searchLine")) != null) {
            OpenSearchActions openSearchActions = new OpenSearchActions();
            BowProxy proxy = BowProxy.getInstance();
            String[] words = search.split("\\s+");
            ArrayList<String> searchLine = new ArrayList<String>(Arrays.asList(words));
            if (search.charAt(search.length() - 1) == ' ') {
                searchLine.add("");
            }
            Criteria criteria = null;
            if (searchLine.size() > 1) {
                ArrayList<String> cpy = new ArrayList<String>(searchLine);
                cpy.remove(cpy.size() - 1);
                criteria = Search.query().eq("Bookmark.email", user.getEmail()).eq("Bookmark.tags", cpy).criteria().addFacetField("Bookmark.tags");
            } else {
                criteria = Search.query().eq("Bookmark.email", user.getEmail()).criteria().addFacetField("Bookmark.tags");
            }
            PagedResult result = proxy.findAllByCriteria(Bookmark.class, criteria);
            List bookList = result.getAll();
            List topics = result.getTopic("Bookmark.tags");
            openSearchActions.setBookmarkList(bookList);
            openSearchActions.setSuggestionList(topics);
            openSearchActions.findSuggestions(searchLine);
            request.setAttribute("openSearchAction", (Object)openSearchActions);
        }
    }

    protected void actionLogout(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException, ServletException {
        session.invalidate();
        request.getRequestDispatcher("login.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void actionAddClick(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        BowProxy proxy;
        Bookmark bookmark;
        String bookmarkId = request.getParameter("bookmarkId");
        if (bookmarkId != null && !bookmarkId.isEmpty() && (bookmark = (Bookmark)(proxy = BowProxy.getInstance()).restore(Bookmark.class, bookmarkId)) != null) {
            int click = bookmark.getClick();
            bookmark.setClick(++click);
            proxy.store((BusinessEntity)bookmark);
            String link = bookmark.getLink();
            response.sendRedirect(link);
        }
    }

    protected void actionOrder(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, ServletException {
        String type = request.getParameter("type");
        String searchLine = request.getParameter("searchLine");
        Criteria baseCriteria = this.getBookmarkListCriteriaByUser(user, searchLine);
        if (type != null && baseCriteria != null && !type.isEmpty()) {
            Criteria criteria;
            BowProxy proxy = BowProxy.getInstance();
            PagedResult result = null;
            if (type.equals("ascName")) {
                criteria = baseCriteria.addSortAscending("Bookmark.description");
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("ascDate")) {
                criteria = baseCriteria.addSortAscending("Bookmark.date");
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("ascClick")) {
                criteria = baseCriteria.addSortAscending("Bookmark.click");
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("descName")) {
                criteria = baseCriteria.addSortDescending("Bookmark.description");
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("descDate")) {
                criteria = baseCriteria.addSortDescending("Bookmark.date");
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            } else if (type.equals("descClick")) {
                criteria = baseCriteria.addSortDescending("Bookmark.click");
                result = proxy.findAllByCriteria(Bookmark.class, criteria);
            }
            BookmarkActions bookmarkActions = this.createBookmarkActions(request, result, searchLine);
            request.setAttribute("bookmarkActions", (Object)bookmarkActions);
        }
    }

    protected void actionEditBookmark(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, ServletException {
        String searchLine;
        BowProxy proxy;
        Bookmark bookmark;
        String bookmarkId = request.getParameter("bookmarkId");
        if (bookmarkId != null && !bookmarkId.isEmpty() && (bookmark = (Bookmark)(proxy = BowProxy.getInstance()).restore(Bookmark.class, bookmarkId)) != null) {
            request.setAttribute("link", (Object)bookmark.getLink());
            request.setAttribute("name", (Object)bookmark.getDescription());
            request.setAttribute("alias", (Object)bookmark.getAlias());
            request.setAttribute("tags", (Object)BookmarkActions.getBookmarkTagsString((Bookmark)bookmark));
            request.setAttribute("action", (Object)"bow?action=modifyBookmark");
            request.setAttribute("bookmarkId", (Object)bookmarkId);
        }
        if ((searchLine = request.getParameter("searchLine")) == null) {
            this.actionHome(request, user);
        } else {
            this.actionSearch(request, user);
        }
        request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void actionRemoveBookmark(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, ServletException {
        BowProxy proxy;
        Bookmark bookmark;
        String bookmarkId = request.getParameter("bookmarkId");
        if (bookmarkId != null && !bookmarkId.isEmpty() && (bookmark = (Bookmark)(proxy = BowProxy.getInstance()).restore(Bookmark.class, bookmarkId)) != null) {
            proxy.delete(bookmarkId);
        }
        this.redirectToTheGoodPage(request, response);
    }

    protected void actionDeleteTag(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, ServletException {
        BowProxy proxy;
        Bookmark bookmark;
        String bookmarkId = request.getParameter("bookmarkId");
        String tag = request.getParameter("deleteTag");
        if (tag != null && bookmarkId != null && !bookmarkId.isEmpty() && (bookmark = (Bookmark)(proxy = BowProxy.getInstance()).restore(Bookmark.class, bookmarkId)) != null) {
            bookmark.removeTags(tag);
            proxy.store((BusinessEntity)bookmark);
        }
        this.redirectToTheGoodPage(request, response);
    }

    protected void actionGenerateToken(HttpServletRequest request, HttpServletResponse response, User user, HttpSession session) throws IOException, ServletException, NoSuchAlgorithmException {
        TokenActions tokenActions;
        Criteria criteria;
        BowProxy proxy = BowProxy.getInstance();
        Token currentToken = (Token)proxy.findByCriteria(Token.class, criteria = Search.query().eq("Token.email", user.getEmail()).criteria());
        if (currentToken != null) {
            String id = currentToken.getWikittyId();
            proxy.delete(id);
        }
        if ((tokenActions = (TokenActions)session.getAttribute("tokenActions")) != null) {
            String token = tokenActions.generateToken();
            criteria = Search.query().eq("Token.token", token).criteria();
            Token oldToken = (Token)proxy.findByCriteria(Token.class, criteria);
            if (oldToken == null) {
                TokenImpl newToken = new TokenImpl();
                newToken.setToken(token);
                newToken.setEmail(user.getEmail());
                proxy.store((BusinessEntity)newToken);
                tokenActions.setPermanentToken(token);
            } else {
                tokenActions.setPermanentToken("");
            }
        }
    }

    protected void actionModifyBookmark(HttpServletRequest request, HttpServletResponse response, User user) throws IOException {
        String link = request.getParameter("url");
        String name = request.getParameter("name");
        String alias = request.getParameter("alias");
        String tags = request.getParameter("tags");
        String id = request.getParameter("bookmarkId");
        BowProxy proxy = BowProxy.getInstance();
        Bookmark bookmark = (Bookmark)proxy.restore(Bookmark.class, id);
        if (bookmark != null) {
            Criteria criteria = Search.query().eq("Bookmark.alias", alias).criteria();
            if (proxy.findByCriteria(Bookmark.class, criteria) != null) {
                alias = bookmark.getAlias();
            }
            BookmarkActions.updateBookmark((Bookmark)bookmark, (String)name, (String)link, (String)tags, (String)alias);
            proxy.store((BusinessEntity)bookmark);
        }
        this.redirectToTheGoodPage(request, response);
    }

    protected void actionAddUrl(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, ServletException {
        this.addUrl(request, user);
        this.redirectToTheGoodPage(request, response);
    }

    protected void addUrl(HttpServletRequest request, User user) {
        String link = request.getParameter("url");
        String name = request.getParameter("name");
        String alias = request.getParameter("alias");
        BowProxy proxy = BowProxy.getInstance();
        Bookmark bookmark = null;
        if (name != null) {
            Criteria criteria;
            String tags = request.getParameter("tags");
            if (alias != null && !alias.isEmpty() && proxy.findByCriteria(Bookmark.class, criteria = Search.query().eq("Bookmark.alias", alias).criteria()) != null) {
                alias = "";
            }
            bookmark = BookmarkActions.createBookmark((String)link, (String)name, (String)tags, (User)user, (String)alias, null);
        } else {
            String nameAndTags = request.getParameter("nameAndTags");
            bookmark = BookmarkActions.createBookmark((String)link, (String)nameAndTags, (User)user);
        }
        if (bookmark != null) {
            proxy.store((BusinessEntity)bookmark);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding URL");
            }
        }
    }

    protected User checkToken(String token, HttpSession session) {
        if (this.checkTemporaryToken(token, session)) {
            User user = (User)session.getAttribute("user");
            return user;
        }
        User user = this.checkPermanentToken(token);
        return user;
    }

    protected User checkPermanentToken(String token) {
        Criteria criteria;
        BowProxy proxy;
        Token DbToken;
        if (token != null && (DbToken = (Token)(proxy = BowProxy.getInstance()).findByCriteria(Token.class, criteria = Search.query().eq("Token.token", token).criteria())) != null) {
            String userEmail = DbToken.getEmail();
            criteria = Search.query().eq("User.email", userEmail).criteria();
            return (User)proxy.findByCriteria(User.class, criteria);
        }
        return null;
    }

    protected boolean checkTemporaryToken(String token, HttpSession session) {
        String temporaryToken;
        TokenActions tokenActions = (TokenActions)session.getAttribute("tokenActions");
        return tokenActions != null && (temporaryToken = tokenActions.getTemporaryToken()) != null && temporaryToken.equals(token);
    }

    protected void actionSearch(HttpServletRequest request, User user) throws IOException, ServletException {
        String searchLine = request.getParameter("searchLine");
        String tag = request.getParameter("addTag");
        if (tag != null && !tag.isEmpty()) {
            searchLine = searchLine == null || searchLine.isEmpty() ? tag : searchLine + " " + tag;
        }
        BowProxy proxy = BowProxy.getInstance();
        Criteria criteria = this.getBookmarkListCriteriaByUser(user, searchLine);
        criteria = criteria.addSortDescending("Bookmark.click");
        PagedResult result = proxy.findAllByCriteria(Bookmark.class, criteria);
        BookmarkActions bookmarkActions = this.createBookmarkActions(request, result, searchLine);
        request.setAttribute("bookmarkActions", (Object)bookmarkActions);
    }

    protected BookmarkActions createBookmarkActions(HttpServletRequest request, PagedResult result, String searchLine) {
        String fullText = request.getParameter("fullTextLine");
        BookmarkActions bookmarkActions = new BookmarkActions();
        List bookList = result.getAll();
        if (bookList != null) {
            bookmarkActions.setBookmarks(bookList);
        }
        if (fullText == null || fullText.isEmpty()) {
            if (searchLine != null && searchLine.isEmpty()) {
                bookmarkActions.emptySearchline();
            } else {
                bookmarkActions.addTags(searchLine);
            }
        }
        List topics = result.getTopic("Bookmark.tags");
        bookmarkActions.createTagCloud(topics);
        return bookmarkActions;
    }

    protected void actionRegister(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException, ServletException, NoSuchAlgorithmException, AddressException, MessagingException {
        String password;
        String md5;
        String email = request.getParameter("email");
        if (this.checkRegister(email, md5 = StringUtil.encodeMD5((String)(password = request.getParameter("password"))))) {
            String error = "Email and password must be correctly filled";
            request.setAttribute("msgError", (Object)error);
            request.getRequestDispatcher("register.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            BowProxy proxy = BowProxy.getInstance();
            UserImpl newUser = new UserImpl();
            newUser.setPassword(md5);
            newUser.setEmail(email);
            User login = (User)proxy.store((BusinessEntity)newUser);
            if (login == null) {
                request.getRequestDispatcher("error.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                session.setAttribute("user", (Object)login);
                Preference preference = (Preference)proxy.restore(Preference.class, login.getWikittyId());
                session.setAttribute("preference", (Object)preference);
                this.initializeToken(session, login);
                this.actionHome(request, login);
                this.checkAdmin(email, session);
                this.sendMail(email, password);
                request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected void actionLogin(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException, ServletException, NoSuchAlgorithmException {
        String email = request.getParameter("email");
        String password = request.getParameter("password");
        User login = this.checkLogin(email, password = StringUtil.encodeMD5((String)password));
        if (login != null) {
            BowProxy proxy = BowProxy.getInstance();
            session.setAttribute("user", (Object)login);
            Preference preference = (Preference)proxy.restore(Preference.class, login.getWikittyId());
            session.setAttribute("preference", (Object)preference);
            this.initializeToken(session, login);
            this.checkAdmin(email, session);
            this.actionHome(request, login);
            request.getRequestDispatcher("main.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            String error = "Unknow email or incorrect password";
            request.setAttribute("msgError", (Object)error);
            request.getRequestDispatcher("login.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void checkAdmin(String login, HttpSession session) {
        String[] admins = BowConfig.getInstance().getAdmins();
        if (admins != null) {
            for (int count = 0; count < admins.length; ++count) {
                if (!login.equals(admins[count])) continue;
                session.setAttribute("admin", (Object)true);
                return;
            }
        }
        session.setAttribute("admin", (Object)false);
    }

    protected void initializeToken(HttpSession session, User login) throws NoSuchAlgorithmException {
        BowProxy proxy = BowProxy.getInstance();
        Criteria criteria = Search.query().eq("Token.email", login.getEmail()).criteria();
        Token token = (Token)proxy.findByCriteria(Token.class, criteria);
        TokenActions tokenActions = new TokenActions();
        if (token == null) {
            token = new TokenImpl();
            String newToken = tokenActions.generateToken();
            token.setToken(newToken);
            token.setEmail(login.getEmail());
            proxy.store((BusinessEntity)token);
        }
        tokenActions.setPermanentToken(token.getToken());
        String temporaryToken = tokenActions.generateToken();
        tokenActions.setTemporaryToken(temporaryToken);
        session.setAttribute("tokenActions", (Object)tokenActions);
    }

    protected User checkLogin(String email, String password) {
        if (email != null && password != null && !email.isEmpty() && !password.isEmpty()) {
            BowProxy proxy = BowProxy.getInstance();
            Criteria criteria = Search.query().eq("User.email", email).eq("User.password", password).criteria();
            return (User)proxy.findByCriteria(User.class, criteria);
        }
        return null;
    }

    protected boolean checkRegister(String email, String password) {
        Criteria criteria;
        BowProxy proxy;
        return email == null || password == null || email.isEmpty() || password.isEmpty() || (proxy = BowProxy.getInstance()).findByCriteria(User.class, criteria = Search.query().eq("User.email", email).criteria()) != null;
    }

    protected void actionHome(HttpServletRequest request, User user) {
        BowProxy proxy = BowProxy.getInstance();
        Criteria criteria = this.getBookmarkListCriteriaByUser(user, null);
        if (criteria != null) {
            Criteria sortCriteria = criteria.addSortDescending("Bookmark.click");
            PagedResult result = proxy.findAllByCriteria(Bookmark.class, sortCriteria);
            sortCriteria = criteria.addSortDescending("Bookmark.date").setEndIndex(10);
            List lastBookmarks = proxy.findAllByCriteria(Bookmark.class, sortCriteria).getAll();
            BookmarkActions bookmarkActions = this.createBookmarkActions(request, result, null);
            bookmarkActions.setTagSearch(null);
            List bookList = bookmarkActions.getBookmarks();
            if (bookList.size() > 10) {
                bookList = bookmarkActions.getBookmarks().subList(0, 10);
                bookmarkActions.setBookmarks(bookList);
            }
            if (lastBookmarks != null) {
                bookmarkActions.setLastBookmarks(lastBookmarks);
            }
            request.setAttribute("bookmarkActions", (Object)bookmarkActions);
        }
    }

    protected void actionImportBookmarks(HttpServletRequest request, HttpServletResponse response, User user) throws IOException, FileUploadException, ParserException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                BowProxy proxy = BowProxy.getInstance();
                String content = item.getString();
                Parser parser = new Parser(content);
                NodeList list = parser.parse(null);
                ArrayList bookmarks = new ArrayList();
                this.parseHtmlToBookmarks(list, user, bookmarks, new ArrayList());
                proxy.store(bookmarks);
            }
        }
        this.redirectToTheGoodPage(request, response);
    }

    protected void parseHtmlToBookmarks(NodeList list, User user, List<Bookmark> bookmarks, List<String> tagList) throws ParserException {
        if (list != null) {
            int index;
            boolean isFolder = false;
            SimpleNodeIterator it = list.elements();
            while (it.hasMoreNodes()) {
                NodeList children;
                Node node = it.nextNode();
                String plainText = node.toPlainTextString();
                String text = node.getText();
                if (text != null && text.startsWith("H3")) {
                    if (plainText != null && !plainText.isEmpty()) {
                        tagList.add(plainText);
                        isFolder = true;
                    }
                } else if (text != null && text.startsWith("A HREF")) {
                    Bookmark bookmark = BookmarkActions.createBookmarkFromHtml((String)text, (String)plainText, (User)user);
                    BookmarkActions.addTagsToBookmark(tagList, (Bookmark)bookmark);
                    if (bookmark != null) {
                        bookmarks.add(bookmark);
                    }
                }
                if ((children = node.getChildren()) == null) continue;
                this.parseHtmlToBookmarks(children, user, bookmarks, tagList);
            }
            if (isFolder && (index = tagList.size() - 1) > -1) {
                tagList.remove(index);
            }
        }
    }

    protected void actionExportBookmarks(HttpServletResponse response, User user) throws IOException {
        BowProxy proxy = BowProxy.getInstance();
        Criteria criteria = Search.query().eq("Bookmark.email", user.getEmail()).criteria();
        List bookmarks = proxy.findAllByCriteria(Bookmark.class, criteria).getAll();
        String export = BookmarkActions.getExportHtmlBookmark((List)bookmarks);
        byte[] buff = export.getBytes();
        ServletOutputStream op = response.getOutputStream();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"bookmarks.html\"");
        response.setContentLength(buff.length);
        op.write(buff, 0, buff.length);
        op.flush();
        op.close();
    }

    protected void actionAddAlias(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Bookmark bookmark;
        String id;
        Criteria criteria;
        BowProxy proxy;
        List bookmarks;
        String alias = request.getParameter("alias");
        if (!(alias == null || alias.isEmpty() || (bookmarks = (proxy = BowProxy.getInstance()).findAllByCriteria(Bookmark.class, criteria = Search.query().eq("Bookmark.alias", alias).criteria()).getAll()) != null && !bookmarks.isEmpty() || (id = request.getParameter("bookmarkId")) == null || id.isEmpty() || (bookmark = (Bookmark)proxy.restore(Bookmark.class, id)) == null)) {
            bookmark.setAlias(alias);
            proxy.store((BusinessEntity)bookmark);
        }
        this.redirectToTheGoodPage(request, response);
    }

    protected void actionFullText(HttpServletRequest request, User user) {
        String fullText = request.getParameter("fullTextLine");
        BowProxy proxy = BowProxy.getInstance();
        Criteria criteria = null;
        criteria = fullText != null && !fullText.isEmpty() ? Search.query().keyword(fullText).eq("Bookmark.email", user.getEmail()).criteria().addFacetField("Bookmark.tags") : this.getBookmarkListCriteriaByUser(user, null);
        PagedResult result = proxy.findAllByCriteria(Bookmark.class, criteria);
        BookmarkActions bookmarkActions = this.createBookmarkActions(request, result, null);
        request.setAttribute("bookmarkActions", (Object)bookmarkActions);
    }

    protected void redirectToTheGoodPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String searchLine = request.getParameter("searchLine");
        String fullText = request.getParameter("fullTextLine");
        if (fullText == null) {
            fullText = "";
        }
        if (searchLine != null) {
            response.sendRedirect("bow?action=search&searchLine=" + searchLine + "&fullTextLine=" + fullText);
        } else {
            response.sendRedirect("bow?action=home");
        }
    }

    protected Criteria getBookmarkListCriteriaByUser(User user, String searchLine) {
        Criteria criteria = null;
        if (user != null) {
            if (searchLine != null && !searchLine.isEmpty()) {
                String[] words = searchLine.split("\\s+");
                ArrayList<String> tags = new ArrayList<String>(Arrays.asList(words));
                criteria = Search.query().eq("Bookmark.email", user.getEmail()).eq("Bookmark.tags", tags).criteria().addFacetField("Bookmark.tags");
            } else {
                criteria = Search.query().eq("Bookmark.email", user.getEmail()).criteria().addFacetField("Bookmark.tags");
            }
        }
        return criteria;
    }

    private void actionChangePreferences(HttpServletRequest request, HttpSession session, User user) throws NoSuchAlgorithmException, AddressException, MessagingException {
        BowProxy proxy = BowProxy.getInstance();
        Preference preference = (Preference)session.getAttribute("preference");
        String colors = request.getParameter("colors");
        String tags = request.getParameter("tags");
        String bookmarks = request.getParameter("bookmarks");
        String searchEngineSuggestions = request.getParameter("searchEngineUrlSuggestions");
        String searchEngineResults = request.getParameter("searchEngineUrlResults");
        preference.setColors(colors);
        preference.setTags(Integer.valueOf(tags).intValue());
        preference.setBookmarks(Integer.valueOf(bookmarks).intValue());
        preference.setSearchEngineUrlSuggestions(searchEngineSuggestions);
        preference.setSearchEngineUrlResults(searchEngineResults);
        proxy.store((BusinessEntity)preference);
        User newUser = (User)proxy.restore(User.class, user.getWikittyId());
        String email = request.getParameter("email");
        String newPassword = request.getParameter("newPassword");
        String currentPassword = request.getParameter("currentPassword");
        String confirmNewPassword = request.getParameter("confirmNewPassword");
        if (email != null && !email.isEmpty()) {
            newUser.setEmail(email);
        }
        if (newPassword != null && confirmNewPassword != null && currentPassword != null && !newPassword.isEmpty() && !confirmNewPassword.isEmpty() && !currentPassword.isEmpty() && newPassword.equals(confirmNewPassword) && (currentPassword = StringUtil.encodeMD5((String)currentPassword)).equals(newUser.getPassword())) {
            String md5 = StringUtil.encodeMD5((String)newPassword);
            newUser.setPassword(md5);
        }
        newUser = (User)proxy.store((BusinessEntity)newUser);
        session.setAttribute("user", (Object)newUser);
        preference = (Preference)proxy.restore(Preference.class, newUser.getWikittyId());
        session.setAttribute("preference", (Object)preference);
    }

    protected void sendMail(String email, String password) throws AddressException, MessagingException {
        BowConfig config = BowConfig.getInstance();
        String smtpServer = config.getSmtpServer();
        Properties properties = new Properties();
        properties.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance((Properties)properties, null);
        session.setDebug(true);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress toAddress = new InternetAddress(email);
        msg.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        String addressFrom = config.getAddressFrom();
        InternetAddress fromAddress = new InternetAddress(addressFrom);
        msg.setFrom((Address)fromAddress);
        String messageSubject = "[Bow] New Password";
        msg.setSubject(messageSubject);
        String messageBody = "Hi,\n\n";
        messageBody = messageBody + "Your new password: " + password + "\n";
        messageBody = messageBody + "Your email: " + email + "\n\n";
        msg.setContent((Object)messageBody, "text/plain");
        Transport.send((Message)msg);
    }

    protected boolean passwordExists(String password) {
        Criteria criteria;
        BowProxy proxy = BowProxy.getInstance();
        List users = proxy.findAllByCriteria(User.class, criteria = Search.query().eq("User.password", password).criteria()).getAll();
        return users != null && users.size() > 0;
    }

    protected void actionSendPassword(HttpServletRequest request, HttpServletResponse response) throws NoSuchAlgorithmException, AddressException, MessagingException, ServletException, IOException {
        String email = request.getParameter("email");
        if (email != null && !email.isEmpty()) {
            Criteria criteria;
            BowProxy proxy = BowProxy.getInstance();
            User user = (User)proxy.findByCriteria(User.class, criteria = Search.query().eq("User.email", email).criteria());
            if (user != null) {
                boolean bool = true;
                String password = "";
                String md5 = "";
                while (bool) {
                    password = RandomStringUtils.randomAlphanumeric((int)20);
                    md5 = StringUtil.encodeMD5((String)password);
                    bool = this.passwordExists(md5);
                }
                this.sendMail(email, password);
                user.setPassword(md5);
                proxy.store((BusinessEntity)user);
                request.getRequestDispatcher("login.jsp").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                request.setAttribute("msgError", (Object)"This email doesn't exist...");
                request.getRequestDispatcher("forgotPassword.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            request.setAttribute("msgError", (Object)"Please enter an email");
            request.getRequestDispatcher("forgotPassword.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void actionReIndexation(HttpServletRequest request, HttpSession session, User user) {
        BowProxy proxy = BowProxy.getInstance();
        proxy.getWikittyService().syncEngin(proxy.getSecurityToken());
    }
}

