/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkImpl;
import org.chorem.bow.BowConfig;
import org.chorem.bow.PreferenceImpl;
import org.chorem.bow.TokenImpl;
import org.chorem.bow.UserImpl;
import org.chorem.bow.UserMigration;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.jdbc.WikittyServiceJDBC;

public class BowProxy
extends WikittyProxy {
    private static Log log = LogFactory.getLog(BowProxy.class);
    protected static BowProxy instance;

    public static synchronized BowProxy getInstance() {
        if (instance == null) {
            BowConfig config = BowConfig.getInstance();
            instance = new BowProxy(config);
            WikittyExtensionMigration.migrationRegistry.put("User", new UserMigration());
        }
        return instance;
    }

    protected BowProxy(BowConfig config) {
        List<WikittyExtension> extensions = Arrays.asList(UserImpl.extensionUser, PreferenceImpl.extensionPreference, BookmarkImpl.extensionBookmark, TokenImpl.extensionToken);
        WikittyServiceJDBC ws = new WikittyServiceJDBC(config.getFlatOptions());
        ws = new WikittyServiceCached((WikittyService)ws);
        String token = super.getSecurityToken();
        ws.storeExtension(token, extensions);
        this.setWikittyService((WikittyService)ws);
    }
}

