/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.chorem.bow.Bookmark;
import org.chorem.bow.BookmarkImpl;
import org.chorem.bow.User;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.FacetTopic;

/*
 * Exception performing whole class analysis ignored.
 */
public class BookmarkActions {
    protected String fullTextLine = "";
    protected List<Bookmark> bookmarks = new ArrayList();
    protected List<Bookmark> lastBookmarks = new ArrayList();
    protected List<FacetTopic> tagCloud = new ArrayList();
    protected List<String> tagsSearch = new ArrayList();
    protected int tmax = -1;
    protected int tmin = -1;

    public static Bookmark createBookmarkFromHtml(String html, String name, User user) {
        String link = BookmarkActions.getUrlFromHtml((String)html);
        String tags = BookmarkActions.getTagsFromHtml((String)html);
        Date date = BookmarkActions.getDateFromHtml((String)html);
        Bookmark bookmark = BookmarkActions.createBookmark((String)link, (String)name, (String)tags, (User)user, null, (Date)date);
        return bookmark;
    }

    public static Date getDateFromHtml(String html) {
        String str;
        Pattern p;
        Matcher m;
        Date date = null;
        if (html != null && (m = (p = Pattern.compile("ADD_DATE=\"([^\"]*)\"")).matcher(html)).find() && (str = m.group(1)) != null && !str.isEmpty()) {
            long time = Long.valueOf(str) * 1000L;
            date = new Date(time);
        }
        return date;
    }

    public static String getExportHtmlBookmark(List<Bookmark> bookmarks) {
        String export = "";
        export = "<!DOCTYPE NETSCAPE-Bookmark-file-1>\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\">\n<DL><p>\n";
        if (bookmarks != null) {
            for (Bookmark bookmark : bookmarks) {
                export = export + "<DT><A HREF=\"";
                export = export + bookmark.getLink() + "\" ";
                Date date = bookmark.getDate();
                if (date != null) {
                    long milli = date.getTime();
                    String time = String.valueOf(milli / 1000L);
                    export = export + "ADD_DATE=\"" + time + "\" LAST_MODIFIED=\"" + time + "\" ";
                }
                export = export + "LAST_CHARSET=\"UTF-8\" ";
                Set tags = bookmark.getTags();
                if (tags != null && !tags.isEmpty()) {
                    export = export + "SHORTCUTURL=\"" + BookmarkActions.getBookmarkTagsString((Bookmark)bookmark) + "\"";
                }
                export = export + ">" + bookmark.getDescription() + "</A>\n";
            }
        }
        export = export + "</DL><p>";
        return export;
    }

    public static String getUrlFromHtml(String html) {
        Pattern p;
        Matcher m;
        String url = "";
        if (html != null && (m = (p = Pattern.compile("A HREF=\"([^\"]*)\"")).matcher(html)).find()) {
            url = m.group(1);
        }
        return url;
    }

    public static String getTagsFromHtml(String html) {
        Pattern p;
        Matcher m;
        String tags = "";
        if (html != null && (m = (p = Pattern.compile("SHORTCUTURL=\"([^\"]*)\"")).matcher(html)).find()) {
            tags = m.group(1);
        }
        return tags;
    }

    public static Bookmark createBookmark(String url, String nameAndTags, User user) {
        String name;
        BookmarkImpl bookmark = new BookmarkImpl();
        int nameIndex = nameAndTags.indexOf(124);
        if (nameIndex > 0 && !(name = nameAndTags.substring(0, nameIndex)).isEmpty()) {
            name = name.trim();
            bookmark.setDescription(name);
        }
        String tags = nameAndTags;
        if (nameIndex >= 0) {
            tags = nameAndTags.substring(nameIndex + 1);
        }
        BookmarkActions.addTagsToBookmark((String)tags, (Bookmark)bookmark);
        BookmarkActions.addUrlToBookmark((String)url, (Bookmark)bookmark);
        bookmark.setClick(0);
        bookmark.setEmail(user.getEmail());
        bookmark.setDate(new Date());
        bookmark.setAlias("");
        return bookmark;
    }

    public static void addUrlToBookmark(String url, Bookmark bookmark) {
        if (url != null && !url.isEmpty()) {
            String link = url.trim();
            if (!link.startsWith("http://") && !link.startsWith("https://")) {
                link = "http://" + link;
            }
            bookmark.setLink(link);
        } else {
            bookmark.setLink("");
        }
    }

    public static void addTagsToBookmark(String tags, Bookmark bookmark) {
        if (tags != null && !tags.isEmpty()) {
            tags = tags.trim();
            String[] tagsTab = tags.split("\\s+");
            for (int i = 0; i < tagsTab.length; ++i) {
                Set tagList = bookmark.getTags();
                if (tagList != null && tagsTab[i] != null) {
                    if (tagList.contains(tagsTab[i]) || tagsTab[i].isEmpty()) continue;
                    bookmark.addTags(tagsTab[i]);
                    continue;
                }
                if (tagsTab[i].isEmpty()) continue;
                bookmark.addTags(tagsTab[i]);
            }
        }
    }

    public static void addTagsToBookmark(List<String> tagList, Bookmark bookmark) {
        if (tagList != null && !tagList.isEmpty()) {
            for (String tag : tagList) {
                BookmarkActions.addTagsToBookmark((String)tag, (Bookmark)bookmark);
            }
        }
    }

    public static Bookmark createBookmark(String url, String name, String tags, User user, String alias, Date date) {
        BookmarkImpl bookmark = new BookmarkImpl();
        if (name != null) {
            name = name.trim();
            bookmark.setDescription(name);
        } else {
            bookmark.setDescription("");
        }
        BookmarkActions.addTagsToBookmark((String)tags, (Bookmark)bookmark);
        BookmarkActions.addUrlToBookmark((String)url, (Bookmark)bookmark);
        bookmark.setClick(0);
        bookmark.setEmail(user.getEmail());
        if (date == null) {
            date = new Date();
        }
        bookmark.setDate(date);
        if (alias != null) {
            alias = alias.trim();
            bookmark.setAlias(alias);
        } else {
            bookmark.setAlias("");
        }
        return bookmark;
    }

    public static void updateBookmarkName(Bookmark bookmark, String name) {
        if (name != null) {
            name = name.trim();
            bookmark.setDescription(name);
        }
    }

    public static void updateBookmark(Bookmark bookmark, String name, String link, String tags, String alias) {
        if (name != null) {
            name = name.trim();
            bookmark.setDescription(name);
        }
        BookmarkActions.addUrlToBookmark((String)link, (Bookmark)bookmark);
        bookmark.clearTags();
        BookmarkActions.addTagsToBookmark((String)tags, (Bookmark)bookmark);
        if (alias != null) {
            alias = alias.trim();
            bookmark.setAlias(alias);
        }
    }

    public static String getBookmarkTagsString(Bookmark bookmark) {
        Set tags;
        if (bookmark != null && (tags = bookmark.getTags()) != null) {
            return StringUtil.join((Iterable)tags, (String)" ", (boolean)true);
        }
        return "";
    }

    public void fullText(String line) {
        this.fullTextLine = line;
        String[] fullText = line.split("\\s+");
        ArrayList save = new ArrayList(this.bookmarks);
        for (Bookmark bookmark : save) {
            boolean delete = true;
            Set tags = bookmark.getTags();
            String name = bookmark.getDescription();
            for (String word : fullText) {
                if (tags != null) {
                    for (String tag : tags) {
                        if (!tag.contains(word)) continue;
                        delete = false;
                        break;
                    }
                }
                if (!name.contains(word)) continue;
                delete = false;
            }
            if (!delete) continue;
            this.bookmarks.remove(bookmark);
        }
    }

    public void createTagCloud(List<FacetTopic> cpy) {
        this.setTagCloud(cpy);
        this.deleteTagBySearch();
        this.defineTValues();
    }

    public void setTagCloud(List<FacetTopic> cpy) {
        if (cpy != null) {
            this.tagCloud = new ArrayList<FacetTopic>(cpy);
        }
    }

    public void deleteTagBySearch() {
        ArrayList save = new ArrayList(this.tagCloud);
        for (FacetTopic topic : save) {
            String name = topic.getTopicName();
            if (!this.tagsSearch.contains(name)) continue;
            this.tagCloud.remove(topic);
        }
    }

    public void deleteBookmarkBySearch() {
        ArrayList bookmarksList = new ArrayList(this.bookmarks);
        for (Bookmark bookmark : bookmarksList) {
            Iterator it = this.tagsSearch.iterator();
            boolean remove = false;
            while (it.hasNext() && !remove) {
                String tag = (String)it.next();
                Set tagList = bookmark.getTags();
                if (tagList != null && !tagList.isEmpty()) {
                    if (tagList.contains(tag)) continue;
                    this.bookmarks.remove(bookmark);
                    remove = true;
                    continue;
                }
                this.bookmarks.remove(bookmark);
                remove = true;
            }
        }
    }

    protected void defineTValues() {
        this.tmax = -1;
        this.tmin = -1;
        for (FacetTopic tag : this.tagCloud) {
            int value = tag.getCount();
            if (this.tmax < value) {
                this.tmax = value;
            }
            if (this.tmin == -1) {
                this.tmin = value;
                continue;
            }
            if (this.tmin <= value) continue;
            this.tmin = value;
        }
    }

    public void addTag(String tag) {
        if (!this.tagsSearch.contains(tag)) {
            this.tagsSearch.add(tag);
        }
    }

    public void addTags(String str) {
        if (str != null && !str.isEmpty()) {
            str = str.trim();
            String[] tags = str.split("\\s+");
            for (int i = 0; i < tags.length; ++i) {
                if (this.tagsSearch.contains(tags[i])) continue;
                this.tagsSearch.add(tags[i]);
            }
        }
    }

    public void emptySearchline() {
        ArrayList bookmarkList = new ArrayList(this.bookmarks);
        for (Bookmark bookmark : bookmarkList) {
            Set tags = bookmark.getTags();
            if (tags == null || tags.isEmpty()) continue;
            this.bookmarks.remove(bookmark);
        }
    }

    public void reset() {
        this.bookmarks.clear();
        this.tagCloud.clear();
        this.tagsSearch.clear();
        this.tmax = -1;
        this.tmin = -1;
    }

    public void setBookmarks(List<Bookmark> bookmarksList) {
        ArrayList<Bookmark> newList;
        this.bookmarks = newList = new ArrayList<Bookmark>(bookmarksList);
    }

    public void setLastBookmarks(List<Bookmark> bookmarksList) {
        ArrayList<Bookmark> newList;
        this.lastBookmarks = newList = new ArrayList<Bookmark>(bookmarksList);
    }

    public void setTagSearch(List<String> cpy) {
        this.tagsSearch = cpy;
    }

    public String getSearchLine() {
        if (this.tagsSearch != null) {
            return StringUtil.join((Iterable)this.tagsSearch, (String)" ", (boolean)true);
        }
        return null;
    }

    public int getFont(int ti) {
        int font = 1;
        if (this.tmax > this.tmin) {
            font = 30 * (ti - this.tmin) / (this.tmax - this.tmin);
        }
        if (font < 10) {
            font = 10;
        }
        return font;
    }

    public List<FacetTopic> getTagsCloud() {
        return this.tagCloud;
    }

    public List<String> getTagsSearch() {
        return this.tagsSearch;
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public List<Bookmark> getLastBookmarks() {
        return this.lastBookmarks;
    }

    public int getTmin() {
        return this.tmin;
    }

    public int getTmax() {
        return this.tmax;
    }

    public String getFullTextLine() {
        return this.fullTextLine;
    }
}

