package org.chorem.bow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyUtil;

public abstract class PreferenceAbstract extends BusinessEntityWikitty implements Preference {

    private static final long serialVersionUID = -1600571350L;

    static final public List<WikittyExtension> extensions;
    static final public WikittyExtension extensionPreference =
        new WikittyExtension(EXT_PREFERENCE, "2.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"Numeric tags",
				"Numeric bookmarks",
				"String colors",
				"String searchEngineUrlSuggestions",
				"String searchEngineUrlResults"));
    static {
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();
        // current after requires ones
        exts.add(extensionPreference);

        extensions = Collections.unmodifiableList(exts);
    }

	public PreferenceAbstract() {
		super();
	}

    public PreferenceAbstract(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public PreferenceAbstract(Wikitty wi) {
		super(wi);
	}


    public void setTags(int tags) {
        Object oldValue = getField(EXT_PREFERENCE, "tags");
        getWikitty().setField(EXT_PREFERENCE, "tags", tags);
        getPropertyChangeSupport().firePropertyChange("tags", oldValue, tags);
    }

    public int getTags() {
        int result = getWikitty().getFieldAsInt(EXT_PREFERENCE, "tags");
        return result;
    }


    public void setBookmarks(int bookmarks) {
        Object oldValue = getField(EXT_PREFERENCE, "bookmarks");
        getWikitty().setField(EXT_PREFERENCE, "bookmarks", bookmarks);
        getPropertyChangeSupport().firePropertyChange("bookmarks", oldValue, bookmarks);
    }

    public int getBookmarks() {
        int result = getWikitty().getFieldAsInt(EXT_PREFERENCE, "bookmarks");
        return result;
    }


    public void setColors(String colors) {
        Object oldValue = getField(EXT_PREFERENCE, "colors");
        getWikitty().setField(EXT_PREFERENCE, "colors", colors);
        getPropertyChangeSupport().firePropertyChange("colors", oldValue, colors);
    }

    public String getColors() {
        String result = getWikitty().getFieldAsString(EXT_PREFERENCE, "colors");
        return result;
    }


    public void setSearchEngineUrlSuggestions(String searchEngineUrlSuggestions) {
        Object oldValue = getField(EXT_PREFERENCE, "searchEngineUrlSuggestions");
        getWikitty().setField(EXT_PREFERENCE, "searchEngineUrlSuggestions", searchEngineUrlSuggestions);
        getPropertyChangeSupport().firePropertyChange("searchEngineUrlSuggestions", oldValue, searchEngineUrlSuggestions);
    }

    public String getSearchEngineUrlSuggestions() {
        String result = getWikitty().getFieldAsString(EXT_PREFERENCE, "searchEngineUrlSuggestions");
        return result;
    }


    public void setSearchEngineUrlResults(String searchEngineUrlResults) {
        Object oldValue = getField(EXT_PREFERENCE, "searchEngineUrlResults");
        getWikitty().setField(EXT_PREFERENCE, "searchEngineUrlResults", searchEngineUrlResults);
        getPropertyChangeSupport().firePropertyChange("searchEngineUrlResults", oldValue, searchEngineUrlResults);
    }

    public String getSearchEngineUrlResults() {
        String result = getWikitty().getFieldAsString(EXT_PREFERENCE, "searchEngineUrlResults");
        return result;
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }

    /**
     * Check equality on all field of this extension, and only those.
     */
    static public boolean equals(Wikitty w1, Wikitty w2) {
        boolean result = true;
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_TAGS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_TAGS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_BOOKMARKS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_BOOKMARKS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_COLORS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_COLORS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLSUGGESTIONS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLSUGGESTIONS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }
        if (result) {
            Object f1 = w1.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLRESULTS);
            Object f2 = w2.getFieldAsObject(EXT_PREFERENCE, FIELD_SEARCHENGINEURLRESULTS);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        }

        return result;
    }

} //PreferenceAbstract
