/*
 * #%L
 * BOW UI
 * %%
 * Copyright (C) 2010 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
window.bow = window.bow || {};
window.bow.bowpwd = window.bow.bowpwd || function(hostname, maximum, prefix, include, exclude, suffix) {
    var e = document.activeElement;
    var isInput = e.tagName === "INPUT";
    
    var password = isInput && e.value || prompt("Your private password");
    var config = password.split('|');
    password = config.shift();
    var c;
    while (c=config.shift()) {
        if (c.match(/\s*[0-9]+\s*/)) { // only numbers => maximum
            maximum = parseInt(c);
        } else if (c.match(/\s*\:.+/)){ // begin with ':' => prefix
            prefix = c;
        } else if (c.match(/\s*=.+/)){ // begin with '=' => include
            include = c.trim().substr(1);
        } else if (c.match(/\s*-.+/)){ // begin with '-' => exclude
            exclude = c.trim().substr(1);
        } else if (c.match(/\s*\+.+/)){ // begin with '+' => suffix 
            suffix = c.trimLeft().substr(1);
        } else { // all other is suffix (not obligation to begin with +)
            suffix = c;
        }
    }
    
    password = (prefix || '') + password;
    hostname = hostname || location.hostname;
    maximum = maximum || e.maxLength || 99;
    suffix = suffix || '';

    var result = bow.hash(password, hostname);
    if (include) {
        result = result.replace(RegExp('[^' + include + ']', 'g'), '');
    }
    if (exclude) {
        result = result.replace(RegExp('[' + exclude + ']', 'g'), '');
    }
    result = result.substr(0, maximum);
    result = result + suffix;

    if (isInput) {
        e.value= result;
    } else {
        prompt("Copy your password with Ctrl+C", result);
    }
};

