<%--
  #%L
  BOW UI
  %%
  Copyright (C) 2010 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="s" uri="/struts-tags" %>

<html xmlns="http://www.w3.org/1999/xhtml"
      xmlns:s="http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd"
      xmlns:jsp="http://java.sun.com/JSP/Page">
    
    <head>
        <title><s:text name="bow.search.title" /></title>
    </head>
    <body>
        <div class="menu clearfix">
            <h2>
                <s:if test="first - bowSession.user.bookmarks >= 0">
                    <s:url var="prev" action="home">
                        <s:param name="tagLine" value="%{tagLine}" />
                        <s:param name="fullTextLine" value="%{fullTextLine}" />
                        <s:param name="order" value="%{order}"/>
                        <s:param name="first" value="%{first - bowSession.user.bookmarks}"/>
                    </s:url>
                    <s:a href="%{prev}">&lt;&lt;</s:a>
                </s:if>

                <s:property value="%{first+1}"/>-<s:property value="%{first + bowSession.user.bookmarks}"/>/<s:property value="%{searchResult.bookmarkCount}"/>

                <s:if test="first + bowSession.user.bookmarks < searchResult.bookmarkCount">
                    <s:url var="next" action="home">
                        <s:param name="tagLine" value="%{tagLine}" />
                        <s:param name="fullTextLine" value="%{fullTextLine}" />
                        <s:param name="order" value="%{order}"/>
                        <s:param name="first" value="%{first + bowSession.user.bookmarks}"/>
                    </s:url>
                    <s:a href="%{next}">&gt;&gt;</s:a>
                </s:if>
            </h2>
            
            <s:set name="bookmarksToDelete" value="%{searchResult.bookmarkCount}" />
            <s:if test="%{#bookmarksToDelete > 0}">
                <s:url var="deleteSearchResults" action="deleteSearchResults" escapeAmp="false">
                    <s:param name="tagLine" value="%{tagLine}" />
                    <s:param name="fullTextLine" value="%{fullTextLine}" />
                    <s:param name="order" value="%{order}"/>
                </s:url>
                <s:a id="deleteSearchResultsButton" title="delete all" href="" onclick="deleteConfirmation('%{deleteSearchResults}', %{#bookmarksToDelete}); return(false);"></s:a>
            </s:if>
            <s:form action="home" method="get" theme="simple">
                <label for="order"><s:text name="bow.search.orderby" /></label>
                <s:select id="order" name="order" list="possibleOrder"/>
                <s:submit key="bow.search.submit" name="submit" />
                <s:hidden name="tagLine" value="%{tagLine}" />
                <s:hidden name="fullTextLine" value="%{fullTextLine}" />
                <s:hidden name="first" value="%{first}" />
            </s:form>
        </div>
            <div class="content">
                <s:if test="searchResult.bookmarks.empty">
                    <p class="nobookmarks"><s:text name="bow.bookmarks.noBookmarks" /></p>
                </s:if>
                <s:else>
                    <s:iterator value="searchResult.bookmarks" var="bookmark">
                        <s:set name="bookmark" value="bookmark"/>
                        <s:set name="auths" value="searchResult.getAuthentication(#bookmark)"/>
                        <jsp:include page="inc/bookmark.jsp" flush="true"/>
                    </s:iterator>
                </s:else>
            </div>
    </body>
</html>
