<%--
#%L
bow

$Id$
$HeadURL$
%%
Copyright (C) 2010 CodeLutin
%%
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
#L%
--%>

<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@taglib prefix="s" uri="/struts-tags" %>
<%@taglib uri="/WEB-INF/bowutils" prefix="u" %>

<html xmlns:s="http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd"
      xmlns:jsp="http://java.sun.com/JSP/Page">
<head>
    <title><s:text name="bow.groupView.title"/></title>
</head>
<body>
<div id="content">
    <div class="menu clearfix">
        <h2><s:text name="bow.groupView.title"/></h2>
    </div>
    <s:actionerror/>

    <div class="formFrame fond">
        <s:a action="groupEdit"><s:text name="bow.group.new" /></s:a>
        <ul>
            <s:iterator value="groups" var="group">
                <s:set name="group" value="group"/>
                <li class="public-${u:isPublicGroup(group)}" title="${group.description}">
                    <span class="group-name">${group.name}</span>
                    <span class="group-members">${group.members.size()} <s:text name="bow.group.members"/></span>

                    <span class="group-actions">
                        <s:url var="groupEdit" action="groupEdit" escapeAmp="true">
                            <s:param name="groupId" value="%{#group.wikittyId}" />
                        </s:url>
                        <a class="edit" href="${groupEdit}">edit</a>

                        <s:url var="groupRemoveMe" action="groupRemoveMe" escapeAmp="true">
                            <s:param name="groupId" value="%{#group.wikittyId}" />
                            <s:param name="user" value="%{bowSession.user.wikittyId}" />
                        </s:url>
                        <a class="removeMe" href="${groupRemoveMe}">removeMe</a>

                        <s:url var="atom" action="atom" escapeAmp="true">
                            <s:param name="token" value="%{bowSession.permanentToken}" />
                            <s:param name="tagLine" value="%{'@' + #group.name}" />
                            <s:param name="notmine" value="true" />
                        </s:url>
                        <a class="atom" href="${atom}">atom</a>
                    </span>
                </li>
            </s:iterator>
        </ul>

    </div>

</div>
</body>
</html>
