<%--
#%L
bow

$Id$
$HeadURL$
%%
Copyright (C) 2010 CodeLutin
%%
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
#L%
--%>

<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@taglib prefix="s" uri="/struts-tags" %>

<html xmlns:s="http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd"
      xmlns:jsp="http://java.sun.com/JSP/Page">
<head>
    <title><s:text name="bow.groupEdit.title"/></title>
    <script>
        function addUserEnter(e) {
            if (e.keyCode === 13)  {
                addUser();
                return false;
            }
        }
        function addUser() {
            var members = document.getElementById("members");
            var userLogin = document.getElementById("userLogin");

            if (userLogin.value) {
                var o = document.createElement("option");
                o.value="add " + userLogin.value;
                o.innerHTML = userLogin.value;
                members.appendChild(o);
                userLogin.value = "";
            }
        }

        function removeUser() {
            var members = document.getElementById("members");
            for (var i = 0; i < members.options.length; i++) {
                var o = members.options[i];
                if (o.selected) {
                    members.removeChild(o);
                }
            }
        }

        function prepareSendMembers() {
            var members = document.getElementById("members");
            for (var i = 0; i < members.options.length; i++) {
                members.options[i].selected = true;
            }
        }

        function showAddedMembers() {
            var members = document.getElementById("members");
            for (var i = 0; i < members.options.length; i++) {
                var o = members.options[i];
                if (o.value.indexOf("add ") === 0) { // start with 'add '
                    o.innerHTML = o.value.substring(4);
                }
            }
        }
    </script>
</head>
<body onload="showAddedMembers()">
        <div id="content">
            <div class="menu clearfix">
                <h2><s:text name="bow.groupEdit.title" /></h2>
            </div>
            <div class="formFrame fond">
                <s:form id="groupEditForm" cssClass="pretty-form" action="groupSave"
                        method="post" onsubmit="prepareSendMembers()">
                    <s:hidden name="tagLine" value="%{tagLine}" />
                    <s:hidden name="fullTextLine" value="%{fullTextLine}" />
                    <s:hidden name="groupId" value="%{groupId}"/>

                    <s:if test="config.allowPublicGroup">
                        <s:checkbox labelposition="left" name="public" labelSeparator=" " key="bow.groupEdit.public"
                                    value="%{public}" />
                    </s:if>
                    <s:textfield disabled="%{groupId != null}" name="group.name" labelSeparator=" " key="bow.groupEdit.name"
                                 value="%{group.name}" />

                    <s:textfield name="group.description" labelSeparator=" " key="bow.groupEdit.description"
                                 value="%{group.description}" />

                    <s:select id="members"
                              list="%{group.getMembers(false)}" listKey="wikittyId" listValue="getFqField('WikittyUser.login')"
                              multiple="true" size="10"
                              name="group.members" labelSeparator=" " key="bow.groupEdit.members" />
                    <button type='button' name="-" onclick="removeUser()">-</button>
                    <div><s:textfield id="userLogin" onkeypress="return addUserEnter(event)"/> <button type='button' name="+" onclick="addUser()">+</button></div>

                    <s:submit cssClass="submit-button" key="bow.groupEdit.save" name="submit" />
                    <s:submit cssClass="submit-button" key="bow.groupEdit.delete" name="delete" action="groupDelete"/>
                </s:form>
            </div>
        </div>
</body>
</html>
