<?xml version="1.0" encoding="utf-8"?>
<%--
  #%L
  BOW UI
  %%
  Copyright (C) 2010 - 2015 CodeLutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="application/atom+xml;charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib prefix="s" uri="/struts-tags" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@taglib uri="/WEB-INF/bowutils" prefix="u" %>
<feed xmlns="http://www.w3.org/2005/Atom">
    <s:set name="bowDomain" value="config.bowUrl"/>

    <title>Bow<s:if test="!tagLine.empty"> (${tagLine})</s:if><s:if test="!fullTextLine.empty"> (${fullTextLine})</s:if></title>
    <subtitle>tag='${tagLine}' filter='${fullTextLine}'</subtitle>

    <s:url var="bowUrl" value="%{#bowDomain + 'home.action'}" escapeAmp="true">
        <s:param name="token" value="%{bowSession.permanentToken}" />
        <s:param name="tagLine" value="%{tagLine}" />
        <s:param name="fullTextLine" value="%{fullTextLine}" />
    </s:url>
    <s:url var="atomUrl" value="%{#bowDomain + 'atom.action'}" escapeAmp="true">
        <s:param name="token" value="%{bowSession.permanentToken}" />
        <s:param name="tagLine" value="%{tagLine}" />
        <s:param name="fullTextLine" value="%{fullTextLine}" />
        <s:param name="count" value="%{count}" />
    </s:url>
    <link rel="alternate" type="text/html" href="${bowUrl}"/>
    <link rel="self" type="application/atom+xml" href="${atomUrl}"/>

    <updated><fmt:formatDate value="${date}" pattern="yyyy-MM-dd'T'HH:mm:ssXXX" /></updated>
    <author>
        <name><s:property value="%{bowSession.user.login}" /></name>
        <s:if test="bowSession.user.login.matches('.*@.*\\\\..*')">
            <email><s:property value="%{bowSession.user.login}" /></email>
        </s:if>
    </author>
    <id>${bowUrl}</id>
    <s:url var="favicon" value="%{#bowDomain + 'img/favicon.png'}" />
    <icon>${favicon}</icon>

     <s:iterator value="bookmarks" var="bookmark">
         <s:set name="bookmark" value="bookmark"/>
         <entry>
             <s:set name="title" value="%{bookmarkUtils.getTitle(#bookmark, 100)}"/>
             <title><s:property value="%{#title}" /></title>
             <s:url var="bookmarkUrl" value="%{#bowDomain + 'home.action'}" escapeAmp="true">
                 <s:param name="token" value="%{bowSession.permanentToken}" />
                 <s:param name="listId" value="%{#bookmark.wikittyId}" />
             </s:url>
             <link rel="alternate" type="text/html" href="${bookmarkUrl}"/>
             <link rel="via" href="${bookmark.link}"/>
             <id>${bowDomain}${bookmark.wikittyId}</id>
             <updated><fmt:formatDate value="${bookmark.creationDate}" pattern="yyyy-MM-dd'T'HH:mm:ssXXX" /></updated>
             <author>
                 <name><s:property value="%{#bookmark.getOwner(false).login}" /></name>
                 <s:if test="#bookmark.getOwner(false).login.matches('.*@.*\\\\..*')">
                     <email><s:property value="%{#bookmark.getOwner(false).login}" /></email>
                 </s:if>
             </author>
             <content type="xhtml">
                 <div xmlns="http://www.w3.org/1999/xhtml">
                 <span>
                     <s:set var="favicon" value="#bookmark.favicon"/>
                     <c:if test="${fn:length(favicon) > 0}">
                         <img src="data:image/png;base64,${u:base64(favicon)}"/>
                     </c:if>

                     <span><fmt:formatDate value="${bookmark.creationDate}" pattern="yyyy-MM-dd" /></span>

                     <c:if test="${not empty bookmark.privateAlias}">
                         <span>
                             <s:a href="%{config.aliasUrl + #bookmark.wikittyId}.action"
                                  title="%{#bookmark.link}" target="_blank">
                                 alias: <s:property value="%{#bookmark.privateAlias}" />
                             </s:a>
                         </span>
                     </c:if>
                     <c:if test="${not empty bookmark.publicAlias}">
                         <span>
                             <s:a href="%{config.aliasUrl + #bookmark.publicAlias}.action"
                                  title="%{#bookmark.link}" target="_blank">
                                 alias public: <s:property value="%{#bookmark.publicAlias}" />
                             </s:a>
                         </span>
                     </c:if>
                 </span>

                 <div>
                     <p><s:a href="%{config.aliasUrl + #bookmark.wikittyId}.action"><s:property value="%{#bookmark.link}" /></s:a></p>
                     
                     <h3><s:text name="bow.bookmark.description" /> :</h3>
                     ${u:toHtml(bookmark.description)}
                     <p>
                         <strong><s:text name="bow.bookmark.tags" /> :</strong>
                         <s:iterator value="#bookmark.labels" var="tag">
                             <s:url var="search" value="%{#bowDomain + 'home.action'}" escapeAmp="true">
                                 <s:param name="addTag" value="%{#tag}"/>
                                 <s:param name="tagLine" value="%{tagLine}"/>
                                 <s:param name="fullTextLine" value="%{fullTextLine}"/>
                                 <s:param name="order" value="descDate"/>
                                 <%-- on ne met pas 'first', il faut repartir de 0 --%>
                             </s:url>
                             <a href="${search}"><s:property value="%{#tag}"/></a>
                         </s:iterator>
                     </p>
                 </div>
                 </div>
             </content>
             <s:iterator value="#bookmark.labels" var="tag">
                 <category term="${tag}" />
             </s:iterator>
         </entry>
     </s:iterator>

</feed>