#!/bin/sh

# usage "bowpwd.sh [domain [password]]"
# you can install xclip to directly have you password in clipboard (just paste)

CLIPBOARD=$(which xclip)

compute() {

LENGTH=$1
PREFIX=$2
INCLUDE=$3
EXCLUDE=$4
SUFFIX=$5
DOMAIN=$6
PASSWD=$7

result=$(echo -n "$DOMAIN" |hmac256 --binary "$PREFIX$PASSWD" |base64)

if [ -n "$INCLUDE" ]; then
    result=$(echo -n "$result" |sed -re "s/[^$INCLUDE]//g")
fi

if [ -n "$EXCLUDE" ]; then
    result=$(echo -n "$result" | sed -re "s/[$EXCLUDE]//g")
fi

if [ -n "$LENGTH" ]; then
    result=$(echo -n "$result" | cut -c-$LENGTH)
fi

if [ -n "$SUFFIX" ]; then
    result=$(echo -n "$result" |sed -re "s/(.*)/\1$SUFFIX/g")
fi

if [ -n "$CLIPBOARD" ]; then
    echo -n "$result" | xclip -selection clipboard
    echo "your password is in your clipboard"
else
    echo "$result"
fi

}

#compute $*

DOMAIN=$1
if [ -z "$DOMAIN" ]; then
    read -p "Domain: " DOMAIN
fi
shift

PASSWD=$1
if [ -z "$PASSWD" ]; then
    read -s -p "Password: " PASSWD
fi
shift

