/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.sharedUser;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSharedUser;
import org.chorem.bow.BowSharedUserImpl;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.BusinessEntity;

public class SharedUserEditAction
extends BowBaseAction {
    private static final Log log = LogFactory.getLog(SharedUserEditAction.class);
    private static final long serialVersionUID = 1L;
    protected String sharedUserId;
    protected BowSharedUser sharedUser;

    public String getSharedUserId() {
        return this.sharedUserId;
    }

    public void setSharedUserId(String sharedUserId) {
        this.sharedUserId = sharedUserId;
    }

    public BowSharedUser getSharedUser() {
        if (this.sharedUser == null) {
            this.loadSharedUser();
        }
        return this.sharedUser;
    }

    public void loadSharedUser() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sharedUser load " + this.sharedUser));
        }
        BowProxy proxy = this.getBowProxy();
        if (StringUtils.isBlank((CharSequence)this.sharedUserId)) {
            this.sharedUser = new BowSharedUserImpl();
            BowUser user = this.getBowUser();
            this.sharedUser.setOwner(user);
            String permanentToken = BowUtils.generateToken();
            this.sharedUser.setPermanentToken(permanentToken);
        } else {
            this.sharedUser = (BowSharedUser)proxy.restore(BowSharedUser.class, this.sharedUserId, new String[0]);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sharedUser loaded " + this.sharedUser));
        }
    }

    public String load() throws Exception {
        return "success";
    }

    public String save() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sharedUser save " + this.sharedUser));
        }
        String result = "success";
        try {
            BowProxy proxy = this.getBowProxy();
            if (StringUtils.isNotBlank((CharSequence)this.sharedUser.getLogin())) {
                proxy.store((BusinessEntity)this.sharedUser);
            } else {
                this.addActionError(this.t("bow.sharedUser.name.blank", new Object[0]));
                result = "error";
            }
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }

    public String delete() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sharedUser delete " + this.sharedUser));
        }
        String result = "success";
        try {
            String userLogin = this.getSharedUser().getLogin();
            BowProxy proxy = this.getBowProxy();
            proxy.delete(this.sharedUserId);
            this.getBowSession().removeAndAddTag(Collections.singletonList("#" + userLogin), Collections.singletonList(userLogin));
        }
        catch (Exception eee) {
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
            result = "error";
        }
        return result;
    }
}

