/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.preference;

import com.opensymphony.xwork2.ActionContext;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BowAuthentication;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowImport;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowSearchPrefix;
import org.chorem.bow.BowSession;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.chorem.bow.action.preference.PreferenceBaseAction;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class PreferenceBaseAction
extends BowBaseAction {
    private static final long serialVersionUID = -58341106356599721L;
    private static final Log log = LogFactory.getLog(PreferenceBaseAction.class);
    protected BowAuthentication bowAuth;
    protected String email;
    protected String newPassword;
    protected String currentPassword;
    protected String confirmNewPassword;
    protected String colors;
    protected boolean screenshot;
    protected boolean favicon;
    protected String tagsNb;
    protected String bookmarksHomePage;
    protected List<BowSearchPrefix> searchPrefix;
    protected List<FacetTopic> labels;
    protected String[] selectedLabels;
    protected String rename;
    protected String delete;
    protected String newLabel;
    protected String update;
    protected Map<String, Integer> bookmarksImportDate;

    public static PreferenceBaseAction getAction() {
        Object action = ActionContext.getContext().get("action");
        return (PreferenceBaseAction)action;
    }

    public BowAuthentication getBowAuth() {
        if (this.bowAuth == null) {
            BowSession session = this.getBowSession();
            BowUser user = session.getUser();
            this.bowAuth = session.getAuthentication(user.getWikittyId());
        }
        return this.bowAuth;
    }

    public void setBowAuth(BowAuthentication bowAuth) {
        this.bowAuth = bowAuth;
    }

    public String getNewLabel() {
        return this.newLabel;
    }

    public void setNewLabel(String newLabel) {
        this.newLabel = newLabel;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public String getRename() {
        return this.rename;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public String getDelete() {
        return this.delete;
    }

    public String getColors() {
        return this.colors;
    }

    public void setColors(String colors) {
        this.colors = colors;
    }

    public boolean isScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(boolean screenshot) {
        this.screenshot = screenshot;
    }

    public boolean isFavicon() {
        return this.favicon;
    }

    public void setFavicon(boolean favicon) {
        this.favicon = favicon;
    }

    public String getTagsNb() {
        return this.tagsNb;
    }

    public void setTagsNb(String tagsNb) {
        this.tagsNb = tagsNb;
    }

    public String getBookmarksHomePage() {
        return this.bookmarksHomePage;
    }

    public void setBookmarksHomePage(String bookmarksHomePage) {
        this.bookmarksHomePage = bookmarksHomePage;
    }

    public List<BowSearchPrefix> getSearchPrefix() {
        if (this.searchPrefix == null) {
            this.loadSearchPrefixPref();
        }
        return this.searchPrefix;
    }

    public void setSearchPrefix(List<BowSearchPrefix> searchPrefix) {
        this.searchPrefix = searchPrefix;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getConfirmNewPassword() {
        return this.confirmNewPassword;
    }

    public void setConfirmNewPassword(String confirmNewPassword) {
        this.confirmNewPassword = confirmNewPassword;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public Map<String, Integer> getBookmarksImportDate() {
        return this.bookmarksImportDate;
    }

    public void setBookmarksImportDate(Map<String, Integer> bookmarksImportDate) {
        this.bookmarksImportDate = bookmarksImportDate;
    }

    public List<FacetTopic> getLabels() {
        return this.labels;
    }

    public String[] getSelectedLabels() {
        return this.selectedLabels;
    }

    public void setSelectedLabels(String[] selectedLabels) {
        this.selectedLabels = selectedLabels;
    }

    public Date stringToDate(String date) {
        try {
            Date result = WikittyUtil.parseDate((String)date);
            return result;
        }
        catch (ParseException eee) {
            return new Date(0L);
        }
    }

    protected void load(PreferenceType ... exclude) {
        PreferenceType[] list = PreferenceType.values();
        for (PreferenceType type : exclude) {
            list[type.ordinal()] = null;
        }
        block8: for (PreferenceType type : list) {
            if (type == null) continue;
            switch (1.$SwitchMap$org$chorem$bow$action$preference$PreferenceBaseAction$PreferenceType[type.ordinal()]) {
                case 1: {
                    this.loadUserPref();
                    continue block8;
                }
                case 2: {
                    this.loadAuthPref();
                    continue block8;
                }
                case 3: {
                    this.loadSitePref();
                    this.loadSearchPrefixPref();
                    continue block8;
                }
                case 4: {
                    this.loadLabels();
                    continue block8;
                }
                case 5: {
                    this.loadImport();
                    continue block8;
                }
            }
        }
    }

    protected void loadUserPref() {
        BowSession session = this.getBowSession();
        BowUser user = session.getUser();
        this.setEmail(user.getLogin());
    }

    protected void loadAuthPref() {
    }

    protected void loadSitePref() {
        BowSession session = this.getBowSession();
        BowUser user = session.getUser();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load site pref for " + user));
        }
        this.setColors(user.getColors());
        this.setScreenshot(user.getScreenshot().booleanValue());
        this.setFavicon(user.getFavicon().booleanValue());
        this.setTagsNb(String.valueOf(user.getTags()));
        this.setBookmarksHomePage(String.valueOf(user.getBookmarks()));
    }

    protected void loadSearchPrefixPref() {
        BowSession session = this.getBowSession();
        this.searchPrefix = session.getSearchPrefix();
    }

    protected void loadImport() {
        BowSession session = this.getBowSession();
        BowProxy proxy = session.getProxy();
        BowUser user = session.getUser();
        WikittyQuery criteria = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("BowImport")).eq("WikittyAuthorisation.owner", (Object)user.getWikittyId())).end().addFacetField((Element)BowImport.ELEMENT_FIELD_BOWIMPORT_IMPORTDATE).setOffset(0).setLimit(0);
        List bookmarksImportDate = proxy.findAllByQuery(BowImport.class, criteria).getTopic((Element)BowImport.ELEMENT_FIELD_BOWIMPORT_IMPORTDATE);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (FacetTopic facet : bookmarksImportDate) {
            String dateAsString = facet.getTopicName();
            int count = facet.getCount();
            result.put(dateAsString, count);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("bookmarksByImportDate found : " + result.size()));
        }
        this.setBookmarksImportDate(result.isEmpty() ? null : result);
    }

    protected void loadLabels() {
        BowSession session = this.getBowSession();
        BowProxy proxy = session.getProxy();
        BowUser user = session.getUser();
        String userId = user.getWikittyId();
        WikittyQuery c = ((WikittyQueryMaker)((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()).exteq("WikittyLabel")).eq("WikittyAuthorisation.owner", (Object)userId)).end().setLimit(0).setFacetMinCount(1).setFacetLimit(Integer.MAX_VALUE).addFacetField((Element)BowBookmark.ELEMENT_FIELD_WIKITTYLABEL_LABELS);
        WikittyQueryResult result = proxy.findAllByQuery(Wikitty.class, c);
        this.labels = result.getTopic("WikittyLabel.labels");
    }

    public String input() {
        String result = "success";
        try {
            this.load(new PreferenceType[0]);
        }
        catch (Exception eee) {
            result = "error";
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)"Can't load data preference", (Throwable)eee);
        }
        return result;
    }
}

