/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.preference;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowImportHelper;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.preference.PreferenceBaseAction;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.nuiton.wikitty.entities.Wikitty;

public class ImportBookmarksAction
extends PreferenceBaseAction {
    private static final long serialVersionUID = -5962680416570797028L;
    private static Log log = LogFactory.getLog(ImportBookmarksAction.class);
    protected File upfile;
    protected String upfileContentType;
    protected String upfileFileName;

    public File getUpfile() {
        return this.upfile;
    }

    public void setUpfile(File upfile) {
        this.upfile = upfile;
    }

    public String getUpfileContentType() {
        return this.upfileContentType;
    }

    public void setUpfileContentType(String upfileContentType) {
        this.upfileContentType = upfileContentType;
    }

    public String getUpfileFileName() {
        return this.upfileFileName;
    }

    public void setUpfileFileName(String upfileFileName) {
        this.upfileFileName = upfileFileName;
    }

    protected BowBookmark createBookmarkFromHtml(String html, String name, BowUser user) {
        String link = this.getUrlFromHtml(html);
        String tags = this.getTagsFromHtml(html);
        Date date = this.getDateFromHtml(html);
        BowBookmark bookmark = BookmarkUtils.createBookmark((String)link, (String)name, (String)tags, (BowUser)user, null, null, (Date)date);
        return bookmark;
    }

    protected Date getDateFromHtml(String html) {
        String str;
        Pattern p;
        Matcher m;
        Date date = null;
        if (html != null && (m = (p = Pattern.compile("ADD_DATE=\"([^\"]*)\"")).matcher(html)).find() && (str = m.group(1)) != null && !str.isEmpty()) {
            long time = Long.valueOf(str) * 1000L;
            date = new Date(time);
        }
        return date;
    }

    protected String getUrlFromHtml(String html) {
        Pattern p;
        Matcher m;
        String url = "";
        if (html != null && (m = (p = Pattern.compile("A HREF=\"([^\"]*)\"")).matcher(html)).find()) {
            url = m.group(1);
        }
        return url;
    }

    protected String getTagsFromHtml(String html) {
        Pattern p;
        Matcher m;
        String tags = "";
        if (html != null && (m = (p = Pattern.compile("SHORTCUTURL=\"([^\"]*)\"")).matcher(html)).find()) {
            tags = m.group(1);
        }
        return tags;
    }

    protected void parseHtmlToBookmarks(NodeList list, BowUser user, Date date, List<BowBookmark> bookmarks, Set<String> tagList) throws ParserException {
        SimpleNodeIterator it = list.elements();
        while (it.hasMoreNodes()) {
            NodeList children;
            Node node = it.nextNode();
            String plainText = node.toPlainTextString();
            String text = node.getText();
            if (StringUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)"h3")) {
                if (StringUtils.isNotBlank((CharSequence)plainText)) {
                    tagList.add(plainText);
                }
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)"a href")) {
                BowBookmark bookmark = this.createBookmarkFromHtml(text, plainText, user);
                Wikitty w = (Wikitty)this.getBowProxy().castTo(Wikitty.class, (Object)bookmark);
                BowImportHelper.addExtension((Wikitty)w);
                BowImportHelper.setImportDate((Wikitty)w, (Date)date);
                bookmark.addAllLabels(tagList);
                bookmarks.add(bookmark);
            }
            if ((children = node.getChildren()) == null) continue;
            this.parseHtmlToBookmarks(children, user, date, bookmarks, new HashSet<String>(tagList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        String result = "success";
        log.info((Object)("Importing boormarks : " + this.upfile));
        try {
            BowUser user = this.getBowSession().getUser();
            if (this.upfile != null) {
                BowProxy proxy = this.getBowProxy();
                try {
                    URL url = this.upfile.toURI().toURL();
                    Parser parser = new Parser(url.openConnection());
                    NodeList list = parser.parse(null);
                    ArrayList bookmarks = new ArrayList();
                    this.parseHtmlToBookmarks(list, user, new Date(), bookmarks, new HashSet());
                    proxy.store(bookmarks);
                    this.addActionMessage(this.t("bow.bookmark.import.successful", new Object[0]));
                }
                catch (ParserException eee) {
                    result = "error";
                    log.error((Object)String.format("Can't parse imported file '%s'", this.getUpfileFileName()), (Throwable)eee);
                    this.addActionError(this.t("bow.bookmark.badFileFormat", new Object[0]));
                }
                catch (IOException eee) {
                    result = "error";
                    log.error((Object)String.format("Can't read imported file '%s'", this.getUpfileFileName()), (Throwable)eee);
                    this.addActionError(this.t("bow.error.internal", new Object[0]));
                }
            } else {
                this.addActionError(this.t("bow.bookmark.badFileFormat", new Object[0]));
                result = "error";
            }
        }
        catch (Exception eee) {
            result = "error";
            this.addActionError(this.t("bow.error.internal", new Object[0]));
            log.error((Object)eee.getMessage(), (Throwable)eee);
        }
        finally {
            this.load(new PreferenceBaseAction.PreferenceType[0]);
        }
        return result;
    }
}

