/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.preference;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;

public class ExportBookmarksAction
extends BowBaseAction {
    private static final long serialVersionUID = 45880214686011946L;
    private static Log log = LogFactory.getLog(ExportBookmarksAction.class);
    protected transient InputStream inputStream;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected void generateExportHtmlBookmark(List<BowBookmark> bookmarks, Writer out) throws IOException {
        out.write("<!DOCTYPE NETSCAPE-Bookmark-file-1>\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=UTF-8\">\n<DL><p>\n");
        if (bookmarks != null) {
            for (BowBookmark bookmark : bookmarks) {
                if (bookmark == null) continue;
                out.write("<DT><A HREF=\"");
                out.write(bookmark.getLink() + "\" ");
                Date date = bookmark.getCreationDate();
                if (date != null) {
                    long milli = date.getTime();
                    String time = String.valueOf(milli / 1000L);
                    out.write("ADD_DATE=\"" + time + "\" LAST_MODIFIED=\"" + time + "\" ");
                }
                out.write("LAST_CHARSET=\"UTF-8\" ");
                Set tags = bookmark.getLabels();
                if (tags != null && !tags.isEmpty()) {
                    out.write("SHORTCUTURL=\"" + BookmarkUtils.getBookmarkTagsString((BowBookmark)bookmark) + "\"");
                }
                out.write(">" + bookmark.getDescription() + "</A>\n");
            }
        }
        out.write("</DL><p>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        BowProxy proxy = this.getBowProxy();
        BowUser user = this.getBowSession().getUser();
        WikittyQuery criteria = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyAuthorisation.owner", (Object)user.getWikittyId())).end();
        List bookmarks = proxy.findAllByQuery(BowBookmark.class, criteria).getAll();
        BufferedWriter out = null;
        try {
            File tmp = File.createTempFile("bookmarks", ".tmp.html");
            tmp.deleteOnExit();
            out = new BufferedWriter(new FileWriter(tmp));
            this.generateExportHtmlBookmark(bookmarks, (Writer)out);
            out.close();
            this.inputStream = new FileInputStream(tmp);
            IOUtils.closeQuietly((Writer)out);
        }
        catch (IOException eee) {
            log.error((Object)"Error when exporting bookmarks to HTML : ", (Throwable)eee);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return "success";
    }
}

