/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.opensearch;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.bow.BookmarkUtils;
import org.chorem.bow.BowBookmark;
import org.chorem.bow.BowProxy;
import org.chorem.bow.BowUser;
import org.chorem.bow.BowUtils;
import org.chorem.bow.action.BowBaseAction;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.query.FacetTopic;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class SuggestionAction
extends BowBaseAction {
    private static Log log = LogFactory.getLog(SuggestionAction.class);
    private static final long serialVersionUID = 1L;
    protected String token;
    protected String q;
    protected transient InputStream inputStream;

    public void setToken(String token) {
        this.token = token;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public String tag() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Start opensearch tag suggest for '%s'", this.q));
        }
        ArrayList<Object> json = new ArrayList<Object>();
        ArrayList<String> completions = new ArrayList<String>();
        json.add("'" + this.q + "'");
        json.add(completions);
        if (this.q != null) {
            String lastTag;
            String firstTag;
            BowUser user = this.getBowSession().getUser();
            BowProxy proxy = this.getBowProxy();
            String searchLineStar = this.q + "*";
            if (this.q.contains(" ")) {
                firstTag = StringUtils.substringBeforeLast((String)this.q, (String)" ") + " ";
                lastTag = StringUtils.substringAfterLast((String)this.q, (String)" ");
            } else {
                firstTag = "";
                lastTag = this.q;
            }
            Set searchLineList = BowUtils.getWords((String)searchLineStar);
            WikittyQueryMaker search = BookmarkUtils.addEqUser((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()), (String)user.getWikittyId());
            search.exteq("WikittyLabel");
            search.containsAll("WikittyLabel.labels", (Collection)searchLineList);
            WikittyQuery criteria = search.end().setLimit(0).setFacetMinCount(1).setFacetLimit(Integer.MAX_VALUE).addFacetField((Element)BowBookmark.ELEMENT_FIELD_WIKITTYLABEL_LABELS);
            WikittyQueryResult result = proxy.findAllByQuery(Wikitty.class, criteria);
            List topics = result.getTopic((Element)BowBookmark.ELEMENT_FIELD_WIKITTYLABEL_LABELS);
            if (log.isTraceEnabled()) {
                log.trace((Object)("all topics: %s" + topics));
            }
            int count = user.getTags();
            for (FacetTopic t : topics) {
                String completion = t.getTopicName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("'%s' startsWith '%s' ? ", completion, lastTag));
                }
                if (!completion.startsWith(lastTag)) continue;
                completions.add("'" + firstTag + completion + "'");
                if (--count > 0) continue;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("opensearch suggest result: %s", json));
        }
        this.inputStream = new ReaderInputStream((Reader)new StringReader(((Object)json).toString()));
        return "success";
    }

    public String fulltext() {
        String result = String.format("['%s', []]", this.q);
        this.inputStream = new ReaderInputStream((Reader)new StringReader(result));
        return "success";
    }

    public String alias() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Start opensearch alias suggest for '%s'", this.q));
        }
        ArrayList<Object> json = new ArrayList<Object>();
        ArrayList<String> completions = new ArrayList<String>();
        json.add("'" + this.q + "'");
        json.add(completions);
        if (this.q != null) {
            BowUser user = this.getBowSession().getUser();
            BowProxy proxy = this.getBowProxy();
            String privateAliasStar = this.q + "*";
            WikittyQueryMaker search = BookmarkUtils.addEqUser((WikittyQueryMaker)((WikittyQueryMaker)new WikittyQueryMaker().and()), (String)user.getWikittyId());
            ((WikittyQueryMaker)((WikittyQueryMaker)search.or()).eq("BowBookmark.privateAlias", (Object)privateAliasStar)).eq("BowBookmark.publicAlias", (Object)privateAliasStar);
            WikittyQuery criteria = search.end().setLimit(15);
            WikittyQueryResult result = proxy.findAllByQuery(BowBookmark.class, criteria);
            for (BowBookmark b : result) {
                String completion = b.getPrivateAlias();
                completions.add("'" + completion + "'");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("opensearch alias suggest result: %s", json));
        }
        this.inputStream = new ReaderInputStream((Reader)new StringReader(((Object)json).toString()));
        return "success";
    }
}

