/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.opensearch;

import com.opensymphony.xwork2.ActionContext;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.struts2.ServletActionContext;
import org.chorem.bow.BowConfig;
import org.chorem.bow.BowSearchPrefix;
import org.chorem.bow.action.opensearch.OpenSearchBaseAction;
import org.nuiton.config.ApplicationConfig;

public class OpenSearchSuggestionAction
extends OpenSearchBaseAction {
    private static final Log log = LogFactory.getLog(OpenSearchSuggestionAction.class);
    private static final long serialVersionUID = 1L;
    protected transient InputStream inputStream;

    public static OpenSearchSuggestionAction getAction() {
        Object action = ActionContext.getContext().get("action");
        return (OpenSearchSuggestionAction)action;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executePrefixAction(BowSearchPrefix foundPrefix, String query) {
        String result = String.format("['%s', []]", query);
        try {
            log.trace((Object)("######################### executePrefixAction #################" + query + " - " + foundPrefix));
            ApplicationConfig config = BowConfig.getConfig((String[])new String[0]);
            String action = foundPrefix == null ? BowConfig.getSearchEngine() : foundPrefix.getSuggestion();
            String optionkey = "bow.prefix." + action;
            if (config.hasOption(optionkey)) {
                action = config.getOption(optionkey);
            }
            if (!StringUtils.startsWith((CharSequence)(action = action.replace("{searchTerms}", URLEncoder.encode(query, "UTF-8"))), (CharSequence)"http")) {
                String serveur = ServletActionContext.getRequest().getScheme() + "://" + ServletActionContext.getRequest().getServerName() + ":" + ServletActionContext.getRequest().getServerPort() + ServletActionContext.getRequest().getContextPath();
                if (!StringUtils.startsWith((CharSequence)action, (CharSequence)"/")) {
                    action = "/" + action;
                }
                action = serveur + action + "&token=" + this.getBowSession().getPermanentToken();
            }
            try {
                log.debug((Object)("try to connect to : " + action));
                CloseableHttpClient httpclient = HttpClients.createDefault();
                HttpGet httpGet = new HttpGet(action);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                try {
                    HttpEntity entity = response.getEntity();
                    result = IOUtils.toString((InputStream)entity.getContent());
                    EntityUtils.consume((HttpEntity)entity);
                }
                finally {
                    response.close();
                }
            }
            catch (Exception eee) {
                log.info((Object)("Can't get result for url: " + action), (Throwable)eee);
            }
            finally {
                log.debug((Object)("suggestion: " + result));
            }
        }
        catch (UnsupportedEncodingException eee) {
            log.info((Object)("Can't make suggestion for: " + query), (Throwable)eee);
        }
        this.inputStream = new ReaderInputStream((Reader)new StringReader(result));
        return "success";
    }
}

