/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.bow.action.opensearch;

import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.chorem.bow.BowSearchPrefix;
import org.chorem.bow.action.BowBaseAction;

public abstract class OpenSearchBaseAction
extends BowBaseAction {
    private static final Log log = LogFactory.getLog(OpenSearchBaseAction.class);
    private static final long serialVersionUID = 1L;
    protected String token;
    protected String q;

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    protected abstract String executePrefixAction(BowSearchPrefix var1, String var2);

    public String execute() {
        log.debug((Object)("######################### OpenSearchBaseAction enter #################" + this.q));
        log.debug((Object)("param:" + ServletActionContext.getRequest().getParameterMap()));
        BowSearchPrefix defaultPrefix = null;
        BowSearchPrefix foundPrefix = null;
        List prefixes = this.getBowSession().getSearchPrefix();
        ListIterator i = prefixes.listIterator(prefixes.size());
        while (i.hasPrevious()) {
            BowSearchPrefix prefix = (BowSearchPrefix)i.previous();
            String p = prefix.getPrefix();
            if (StringUtils.isBlank((CharSequence)p)) {
                defaultPrefix = prefix;
                continue;
            }
            if (!StringUtils.startsWith((CharSequence)this.q, (CharSequence)p)) continue;
            foundPrefix = prefix;
            break;
        }
        if (foundPrefix == null) {
            foundPrefix = defaultPrefix;
        }
        String query = foundPrefix == null ? this.q : StringUtils.substringAfter((String)this.q, (String)foundPrefix.getPrefix());
        System.out.println("######################### OpenSearchBaseAction #################" + query + " - " + foundPrefix);
        String result = this.executePrefixAction(foundPrefix, query);
        return result;
    }
}

